/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.logger;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerAdapter;
import com.acgist.snail.logger.LoggerConfig;
import com.acgist.snail.logger.adapter.ConsoleLoggerAdapter;
import com.acgist.snail.logger.adapter.FileLoggerAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LoggerFactory {
    private static final LoggerFactory INSTANCE = new LoggerFactory();
    private static final String ERROR_LOG_FILE = "logs/snail.error.log";
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private final List<LoggerAdapter> adapters;

    public static final LoggerFactory getInstance() {
        return INSTANCE;
    }

    private LoggerFactory() {
        String adapter = LoggerConfig.getAdapter();
        ArrayList<LoggerAdapter> list = new ArrayList<LoggerAdapter>();
        if (adapter != null && !adapter.isEmpty()) {
            String[] adapters;
            for (String value : adapters = SymbolConfig.Symbol.COMMA.split(adapter)) {
                if ("file".equalsIgnoreCase(value = value.strip())) {
                    list.add(new FileLoggerAdapter());
                    continue;
                }
                if (!"console".equalsIgnoreCase(value)) continue;
                list.add(new ConsoleLoggerAdapter());
            }
        }
        this.adapters = list;
    }

    public static final Logger getLogger(Class<?> clazz) {
        return LoggerFactory.INSTANCE.loggers.computeIfAbsent(clazz.getName(), Logger::new);
    }

    public static final List<LoggerAdapter> getAdapters() {
        return LoggerFactory.INSTANCE.adapters;
    }

    public static final void error(Throwable t) {
        try (FileOutputStream outputStream = new FileOutputStream(new File(ERROR_LOG_FILE), true);
             PrintWriter printWriter = new PrintWriter(outputStream);){
            t.printStackTrace(printWriter);
            printWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void shutdown() {
        LoggerFactory.INSTANCE.adapters.forEach(LoggerAdapter::release);
    }
}

