/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.logger;

import java.util.Objects;
import java.util.StringJoiner;

public final class Tuple {
    public static final String FORMAT_CODE = "{}";
    private final String message;
    private final String[] format;
    private final String suffix;

    public Tuple(String message) {
        int pos = 0;
        int last = 0;
        int index = 0;
        this.message = message;
        String[] format = new String[8];
        int messageLength = message.length();
        int formatCodeLength = FORMAT_CODE.length();
        while ((pos = message.indexOf(FORMAT_CODE, last)) >= 0) {
            format[index++] = message.substring(last, pos);
            last = pos + formatCodeLength;
            if (index < format.length) continue;
            String[] resizeFormat = new String[format.length + 8];
            System.arraycopy(format, 0, resizeFormat, 0, format.length);
            format = resizeFormat;
        }
        this.suffix = last != 0 && last < messageLength ? message.substring(last) : null;
        this.format = new String[index];
        System.arraycopy(format, 0, this.format, 0, index);
    }

    public final String format(Object ... objects) {
        StringBuilder builder = new StringBuilder();
        return this.format(builder, objects).toString();
    }

    public final StringBuilder format(StringBuilder builder, Object ... objects) {
        Objects.requireNonNull(builder, "\u6ca1\u6709\u65e5\u5fd7Builder");
        int formatLength = this.format.length;
        if (objects == null || objects.length == 0 || formatLength == 0) {
            builder.append(this.message);
            return builder;
        }
        int objectLength = objects.length;
        for (int index = 0; index < formatLength; ++index) {
            builder.append(this.format[index]);
            if (index < objectLength) {
                Object object = objects[index];
                if (object == null) {
                    builder.append(object);
                    continue;
                }
                if (object.getClass().isArray()) {
                    builder.append(this.array(object));
                    continue;
                }
                builder.append(object);
                continue;
            }
            builder.append(FORMAT_CODE);
        }
        if (this.suffix != null) {
            builder.append(this.suffix);
        }
        return builder;
    }

    public final Throwable throwable(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        Object object = objects[objects.length - 1];
        if (object instanceof Throwable) {
            Throwable t = (Throwable)object;
            return t;
        }
        return null;
    }

    private final String array(Object object) {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        if (object instanceof boolean[]) {
            boolean[] array;
            for (boolean value : array = (boolean[])object) {
                joiner.add(Boolean.toString(value));
            }
        } else if (object instanceof byte[]) {
            byte[] array;
            for (byte value : array = (byte[])object) {
                joiner.add(Byte.toString(value));
            }
        } else if (object instanceof char[]) {
            char[] array;
            for (char value : array = (char[])object) {
                joiner.add(Character.toString(value));
            }
        } else if (object instanceof short[]) {
            short[] array;
            for (short value : array = (short[])object) {
                joiner.add(Short.toString(value));
            }
        } else if (object instanceof int[]) {
            int[] array;
            for (int value : array = (int[])object) {
                joiner.add(Integer.toString(value));
            }
        } else if (object instanceof long[]) {
            long[] array;
            for (long value : array = (long[])object) {
                joiner.add(Long.toString(value));
            }
        } else if (object instanceof float[]) {
            float[] array;
            for (float value : array = (float[])object) {
                joiner.add(Float.toString(value));
            }
        } else if (object instanceof double[]) {
            double[] array;
            for (double value : array = (double[])object) {
                joiner.add(Double.toString(value));
            }
        } else if (object instanceof Object[]) {
            Object[] array;
            for (Object value : array = (Object[])object) {
                joiner.add(String.valueOf(value));
            }
        } else {
            return String.valueOf(object);
        }
        return joiner.toString();
    }
}

