/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.logger.adapter;

import com.acgist.snail.logger.LoggerAdapter;
import com.acgist.snail.logger.LoggerConfig;
import com.acgist.snail.logger.LoggerFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public final class FileLoggerAdapter
extends LoggerAdapter {
    public static final String ADAPTER = "file";
    private static final String FILE_SUFFIX_FORMAT = ".yyyy.MM.dd";

    public FileLoggerAdapter() {
        OutputStream output;
        this.output = output = this.buildOutput();
        this.errorOutput = output;
    }

    @Override
    public void release() {
        File[] logFiles;
        super.release();
        File file = this.buildFile();
        String fileName = file.getName();
        LocalDateTime time = LocalDateTime.now();
        int maxDays = LoggerConfig.getFileMaxDays();
        for (File logFile : logFiles = file.getParentFile().listFiles()) {
            if (!this.deleteable(maxDays, fileName, logFile, time)) continue;
            try {
                Files.delete(logFile.toPath());
            }
            catch (IOException e) {
                LoggerFactory.error(e);
            }
        }
    }

    private OutputStream buildOutput() {
        int fileBuffer = LoggerConfig.getFileBuffer();
        File file = this.buildFile();
        try {
            return new BufferedOutputStream(new FileOutputStream(file, true), fileBuffer);
        }
        catch (IOException e) {
            LoggerFactory.error(e);
            return null;
        }
    }

    private File buildFile() {
        SimpleDateFormat format;
        String fileName = LoggerConfig.getFileName();
        String path = fileName + (format = new SimpleDateFormat(FILE_SUFFIX_FORMAT)).format(new Date());
        File file = new File(path);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return file;
    }

    private boolean deleteable(int maxDays, String fileName, File logFile, LocalDateTime time) {
        if (!logFile.exists() || !logFile.isFile()) {
            return false;
        }
        LocalDateTime modifyTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(logFile.lastModified()), ZoneId.systemDefault());
        long days = Duration.between(modifyTime, time).toDays();
        if (days <= (long)maxDays) {
            return false;
        }
        String logFileName = logFile.getName();
        if (logFileName.length() != fileName.length()) {
            return false;
        }
        int length = logFileName.length() - FILE_SUFFIX_FORMAT.length();
        if (length <= 0) {
            return false;
        }
        return logFileName.substring(0, length).equals(fileName.substring(0, length));
    }
}

