/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.net.IMessageSender;
import com.acgist.snail.net.NetException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public abstract class Client<T extends IMessageSender>
implements IMessageSender {
    protected final String name;
    protected final T handler;

    protected Client(String name, T handler) {
        this.name = name;
        this.handler = handler;
    }

    @Override
    public boolean available() {
        if (this.handler == null) {
            return false;
        }
        return this.handler.available();
    }

    @Override
    public void send(String message) throws NetException {
        this.handler.send(message);
    }

    @Override
    public void send(String message, String charset) throws NetException {
        this.handler.send(message, charset);
    }

    @Override
    public void send(byte[] message) throws NetException {
        this.handler.send(message);
    }

    @Override
    public void send(ByteBuffer buffer) throws NetException {
        this.handler.send(buffer);
    }

    @Override
    public void send(ByteBuffer buffer, int timeout) throws NetException {
        this.handler.send(buffer, timeout);
    }

    @Override
    public InetSocketAddress remoteSocketAddress() {
        return this.handler.remoteSocketAddress();
    }

    @Override
    public void close() {
        if (this.handler == null) {
            return;
        }
        this.handler.close();
    }
}

