/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.net.NetException;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public interface IMessageSender {
    public boolean available();

    default public void send(String message) throws NetException {
        this.send(message, null);
    }

    default public void send(String message, String charset) throws NetException {
        this.send(StringUtils.toBytes(message, charset));
    }

    default public void send(byte[] message) throws NetException {
        this.send(ByteBuffer.wrap(message));
    }

    default public void send(ByteBuffer buffer) throws NetException {
        this.send(buffer, 0);
    }

    public void send(ByteBuffer var1, int var2) throws NetException;

    default public void check(ByteBuffer buffer) throws NetException {
        if (!this.available()) {
            throw new NetException("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u901a\u9053\u4e0d\u53ef\u7528");
        }
        if (buffer.position() != 0) {
            buffer.flip();
        }
    }

    default public void heartbeat() {
    }

    default public void reconnect() {
    }

    public InetSocketAddress remoteSocketAddress();

    public void close();
}

