/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.net.IChannelHandler;
import com.acgist.snail.net.IMessageHandler;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.codec.IMessageDecoder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;

public abstract class MessageHandler<T extends Channel>
implements IMessageHandler,
IChannelHandler<T> {
    protected volatile boolean close = false;
    protected T channel;
    protected IMessageDecoder<ByteBuffer> messageDecoder;

    @Override
    public final boolean available() {
        return !this.close && this.channel != null && this.channel.isOpen();
    }

    @Override
    public void onReceive(ByteBuffer buffer) throws NetException {
        if (this.messageDecoder == null) {
            throw new NetException("\u8bf7\u8bbe\u7f6e\u6d88\u606f\u5904\u7406\u5668\u6216\u91cd\u65b0\u63a5\u6536\u6d88\u606f\u65b9\u6cd5");
        }
        this.messageDecoder.decode(buffer);
    }

    @Override
    public void onReceive(ByteBuffer buffer, InetSocketAddress socketAddress) throws NetException {
        if (this.messageDecoder == null) {
            throw new NetException("\u8bf7\u8bbe\u7f6e\u6d88\u606f\u5904\u7406\u5668\u6216\u91cd\u65b0\u63a5\u6536\u6d88\u606f\u65b9\u6cd5");
        }
        this.messageDecoder.decode(buffer, socketAddress);
    }
}

