/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.context.IContext;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.IMessageHandler;
import com.acgist.snail.net.IMessageSender;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class MessageHandlerContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHandlerContext.class);
    private static final MessageHandlerContext INSTANCE = new MessageHandlerContext();
    private static final int USELESS_INTERVAL = 60;
    private final List<IMessageHandler> handlers = new LinkedList<IMessageHandler>();

    public static final MessageHandlerContext getInstance() {
        return INSTANCE;
    }

    private MessageHandlerContext() {
        SystemThreadContext.scheduledAtFixedDelay(60L, 60L, TimeUnit.SECONDS, this::useless);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newInstance(IMessageHandler handler) {
        List<IMessageHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useless() {
        ArrayList<IMessageHandler> uselessList = new ArrayList<IMessageHandler>();
        List<IMessageHandler> list = this.handlers;
        synchronized (list) {
            int oldSize = this.handlers.size();
            Iterator<IMessageHandler> iterator = this.handlers.iterator();
            while (iterator.hasNext()) {
                IMessageHandler handler = iterator.next();
                if (handler.available()) {
                    if (!handler.useless()) continue;
                    iterator.remove();
                    uselessList.add(handler);
                    continue;
                }
                iterator.remove();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u5904\u7406\u5b8c\u6210\u65e0\u6548\u6d88\u606f\u4ee3\u7406\uff1a{} - {} - {}", oldSize, this.handlers.size(), uselessList.size());
            }
        }
        uselessList.forEach(IMessageSender::close);
    }
}

