/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.IContext;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.stun.StunContext;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.net.upnp.UpnpClient;
import com.acgist.snail.net.upnp.UpnpContext;
import com.acgist.snail.net.upnp.UpnpServer;
import com.acgist.snail.utils.NetUtils;
import java.util.concurrent.TimeUnit;

public final class NatContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(NatContext.class);
    private static final NatContext INSTANCE = new NatContext();
    private static final long MAPPING_TIMEOUT = 2000L;
    private static final int NAT_INTERVAL = 5;
    private Type type = Type.NONE;
    private final Object lock = new Object();

    public static final NatContext getInstance() {
        return INSTANCE;
    }

    private NatContext() {
    }

    public void register() {
        if (NetUtils.localIP(NetUtils.LOCAL_HOST_ADDRESS)) {
            if (this.upnp()) {
                this.type = Type.UPNP;
                LOGGER.debug("\u6ce8\u518cNAT\u670d\u52a1\u6210\u529f\uff1a{}", new Object[]{this.type});
            } else if (this.stun()) {
                this.type = Type.STUN;
                LOGGER.debug("\u6ce8\u518cNAT\u670d\u52a1\u6210\u529f\uff1a{}", new Object[]{this.type});
            } else {
                LOGGER.debug("\u6ce8\u518cNAT\u670d\u52a1\u5931\u8d25\uff1a{}", 5);
                SystemThreadContext.scheduled(5L, TimeUnit.SECONDS, this::register);
            }
        } else {
            LOGGER.debug("\u6ce8\u518cNAT\u670d\u52a1\u6210\u529f\uff1a\u5df2\u662f\u516c\u7f51IP\u5730\u5740", new Object[0]);
            this.type = Type.OPEN;
            SystemConfig.setTorrentPortExt(SystemConfig.getTorrentPort());
            SystemConfig.setExternalIPAddress(NetUtils.LOCAL_HOST_ADDRESS);
            NodeContext.getInstance().buildNodeId(NetUtils.LOCAL_HOST_ADDRESS);
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean upnp() {
        if (!UpnpContext.getInstance().available()) {
            UpnpClient.newInstance().mSearch();
            this.lock();
        }
        if (UpnpContext.getInstance().available()) {
            try {
                return UpnpContext.getInstance().mapping();
            }
            catch (NetException e) {
                LOGGER.error("\u8bbe\u7f6eUPNP\u7a7f\u900f\u5f02\u5e38", e);
            }
        }
        return false;
    }

    public boolean stun() {
        if (StunContext.getInstance().available()) {
            return true;
        }
        StunContext.getInstance().mapping();
        this.lock();
        return StunContext.getInstance().available();
    }

    public void shutdown() {
        LOGGER.debug("\u5173\u95edNAT\u670d\u52a1\uff1a{}", new Object[]{this.type});
        if (this.type == Type.UPNP) {
            UpnpContext.getInstance().release();
            UpnpServer.getInstance().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static enum Type {
        UPNP,
        STUN,
        OPEN,
        NONE;

    }
}

