/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.net.NetException;

public final class PacketSizeException
extends NetException {
    private static final long serialVersionUID = 1L;

    public static final void verify(short length) throws PacketSizeException {
        if (length < 0 || length > 0x400000) {
            throw new PacketSizeException(length);
        }
    }

    public static final void verify(int length) throws PacketSizeException {
        if (length < 0 || length > 0x400000) {
            throw new PacketSizeException(length);
        }
    }

    public PacketSizeException() {
        super("\u7f51\u7edc\u5305\u5927\u5c0f\u5f02\u5e38");
    }

    public PacketSizeException(int size) {
        super("\u7f51\u7edc\u5305\u5927\u5c0f\u9519\u8bef\uff1a" + size);
    }

    public PacketSizeException(String message) {
        super(message);
    }

    public PacketSizeException(Throwable cause) {
        super(cause);
    }

    public PacketSizeException(String message, Throwable cause) {
        super(message, cause);
    }
}

