/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.MessageHandlerContext;
import com.acgist.snail.net.TcpMessageHandler;
import com.acgist.snail.utils.BeanUtils;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;

public final class TcpAcceptHandler<T extends TcpMessageHandler>
implements CompletionHandler<AsynchronousSocketChannel, AsynchronousServerSocketChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpAcceptHandler.class);
    private final Class<T> clazz;
    private final MessageHandlerContext context;

    private TcpAcceptHandler(Class<T> clazz) {
        this.clazz = clazz;
        this.context = MessageHandlerContext.getInstance();
    }

    public static final <T extends TcpMessageHandler> TcpAcceptHandler<T> newInstance(Class<T> clazz) {
        return new TcpAcceptHandler<T>(clazz);
    }

    @Override
    public void completed(AsynchronousSocketChannel channel, AsynchronousServerSocketChannel server) {
        LOGGER.debug("TCP\u8fde\u63a5\u6210\u529f\uff1a{}", channel);
        server.accept(server, this);
        TcpMessageHandler handler = (TcpMessageHandler)BeanUtils.newInstance(this.clazz);
        handler.handle(channel);
        this.context.newInstance(handler);
    }

    @Override
    public void failed(Throwable throwable, AsynchronousServerSocketChannel server) {
        LOGGER.error("TCP\u8fde\u63a5\u5f02\u5e38\uff1a{}", server, throwable);
    }
}

