/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.Client;
import com.acgist.snail.net.TcpMessageHandler;
import com.acgist.snail.utils.IoUtils;
import com.acgist.snail.utils.NetUtils;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class TcpClient<T extends TcpMessageHandler>
extends Client<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpClient.class);
    private static final AsynchronousChannelGroup GROUP;
    private final int timeout;

    protected TcpClient(String name, int timeout, T handler) {
        super(name, handler);
        this.timeout = timeout;
    }

    public abstract boolean connect();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean connect(String host, int port) {
        boolean success;
        block11: {
            AsynchronousSocketChannel channel;
            block8: {
                success = true;
                channel = null;
                try {
                    channel = AsynchronousSocketChannel.open(GROUP);
                    channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                    channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                    Future<Void> future = channel.connect(NetUtils.buildSocketAddress(host, port));
                    future.get(this.timeout, TimeUnit.SECONDS);
                    ((TcpMessageHandler)this.handler).handle(channel);
                    if (!success) break block8;
                }
                catch (InterruptedException e) {
                    block9: {
                        Thread.currentThread().interrupt();
                        LOGGER.error("TCP\u5ba2\u6237\u7aef\u8fde\u63a5\u5f02\u5e38\uff1a{} - {}", host, port, e);
                        success = false;
                        if (!success) break block9;
                        LOGGER.debug("TCP\u8fde\u63a5\u6210\u529f\uff1a{} - {}", host, port);
                    }
                    IoUtils.close(channel);
                    this.close();
                }
                catch (IOException | ExecutionException | TimeoutException e2) {
                    block10: {
                        LOGGER.error("TCP\u5ba2\u6237\u7aef\u8fde\u63a5\u5f02\u5e38\uff1a{} - {}", host, port, e2);
                        success = false;
                        if (!success) break block10;
                        {
                            catch (Throwable throwable) {
                                if (success) {
                                    LOGGER.debug("TCP\u8fde\u63a5\u6210\u529f\uff1a{} - {}", host, port);
                                } else {
                                    IoUtils.close(channel);
                                    this.close();
                                }
                                throw throwable;
                            }
                        }
                        LOGGER.debug("TCP\u8fde\u63a5\u6210\u529f\uff1a{} - {}", host, port);
                    }
                    IoUtils.close(channel);
                    this.close();
                }
                LOGGER.debug("TCP\u8fde\u63a5\u6210\u529f\uff1a{} - {}", host, port);
                break block11;
            }
            IoUtils.close(channel);
            this.close();
        }
        return success;
    }

    @Override
    public void close() {
        LOGGER.debug("\u5173\u95edTCP Client\uff1a{}", this.name);
        super.close();
    }

    public static final void shutdown() {
        LOGGER.debug("\u5173\u95edTCP Client\u7ebf\u7a0b\u6c60", new Object[0]);
        SystemThreadContext.shutdown(GROUP);
    }

    static {
        AsynchronousChannelGroup group = null;
        try {
            ExecutorService executor = SystemThreadContext.newCacheExecutor(0, 60L, "ST-TCP-Client");
            group = AsynchronousChannelGroup.withThreadPool(executor);
        }
        catch (IOException e) {
            LOGGER.error("\u542f\u52a8TCP Client\u7ebf\u7a0b\u6c60\u5f02\u5e38", e);
        }
        GROUP = group;
    }
}

