/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.MessageHandler;
import com.acgist.snail.net.NetException;
import com.acgist.snail.utils.IoUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class TcpMessageHandler
extends MessageHandler<AsynchronousSocketChannel>
implements CompletionHandler<Integer, ByteBuffer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpMessageHandler.class);

    @Override
    public void handle(AsynchronousSocketChannel channel) {
        this.channel = channel;
        this.loopMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ByteBuffer buffer, int timeout) throws NetException {
        this.check(buffer);
        AsynchronousSocketChannel asynchronousSocketChannel = (AsynchronousSocketChannel)this.channel;
        synchronized (asynchronousSocketChannel) {
            try {
                Future<Integer> future = ((AsynchronousSocketChannel)this.channel).write(buffer);
                int size = timeout <= 0 ? future.get().intValue() : future.get(timeout, TimeUnit.SECONDS).intValue();
                if (size <= 0) {
                    LOGGER.warn("TCP\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a{}-{}", this.channel, size);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new NetException(e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new NetException(e);
            }
        }
    }

    @Override
    public InetSocketAddress remoteSocketAddress() {
        try {
            return (InetSocketAddress)((AsynchronousSocketChannel)this.channel).getRemoteAddress();
        }
        catch (IOException e) {
            LOGGER.error("TCP\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u5730\u5740\u5f02\u5e38", e);
            return null;
        }
    }

    @Override
    public void close() {
        if (this.close) {
            return;
        }
        LOGGER.debug("TCP\u8fde\u63a5\u5173\u95ed\uff1a{}", this.channel);
        this.close = true;
        IoUtils.close(this.channel);
    }

    @Override
    public void completed(Integer result, ByteBuffer buffer) {
        if (result == null) {
            this.close();
        } else if (result == -1) {
            this.close();
        } else if (result == 0) {
            LOGGER.debug("TCP\u6d88\u606f\u63a5\u6536\u5931\u8d25\uff08\u957f\u5ea6\uff09\uff1a{}", result);
        } else {
            this.receive(buffer);
        }
        this.loopMessage();
    }

    @Override
    public void failed(Throwable throwable, ByteBuffer buffer) {
        LOGGER.error("TCP\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff1a{}", this.channel, throwable);
        this.close();
    }

    private void receive(ByteBuffer buffer) {
        try {
            if (this.available()) {
                buffer.flip();
                this.onReceive(buffer);
            }
        }
        catch (Exception e) {
            LOGGER.error("TCP\u63a5\u6536\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    private void loopMessage() {
        if (this.available()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            ((AsynchronousSocketChannel)this.channel).read(buffer, buffer, this);
        } else {
            LOGGER.debug("TCP\u6d88\u606f\u4ee3\u7406\u9000\u51fa\u6d88\u606f\u8f6e\u8be2", new Object[0]);
        }
    }
}

