/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.Server;
import com.acgist.snail.net.TcpAcceptHandler;
import com.acgist.snail.net.TcpMessageHandler;
import com.acgist.snail.utils.IoUtils;
import com.acgist.snail.utils.NetUtils;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.concurrent.ExecutorService;

public abstract class TcpServer<T extends TcpMessageHandler>
extends Server<AsynchronousServerSocketChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpServer.class);
    private static final AsynchronousChannelGroup GROUP;
    private final Class<T> clazz;

    protected TcpServer(String name, Class<T> clazz) {
        super(name);
        this.clazz = clazz;
    }

    public abstract boolean listen();

    protected boolean listen(int port) {
        return this.listen(ADDR_LOCAL, port, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean listen(String host, int port, boolean reuse) {
        boolean success;
        block8: {
            block6: {
                LOGGER.debug("\u542f\u52a8TCP\u670d\u52a1\u7aef\uff1a{} - {} - {} - {}", this.name, host, port, reuse);
                success = true;
                try {
                    this.channel = AsynchronousServerSocketChannel.open(GROUP);
                    ((AsynchronousServerSocketChannel)this.channel).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)reuse);
                    ((AsynchronousServerSocketChannel)this.channel).bind(NetUtils.buildSocketAddress(host, port));
                    ((AsynchronousServerSocketChannel)this.channel).accept((AsynchronousServerSocketChannel)this.channel, TcpAcceptHandler.newInstance(this.clazz));
                    if (!success) break block6;
                }
                catch (IOException e) {
                    block7: {
                        try {
                            LOGGER.error("\u542f\u52a8TCP\u670d\u52a1\u7aef\u5f02\u5e38\uff1a{}", this.name, e);
                            success = false;
                            if (!success) break block7;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                LOGGER.debug("\u542f\u52a8TCP\u670d\u52a1\u7aef\u6210\u529f\uff1a{}", this.name);
                            } else {
                                this.close();
                            }
                            throw throwable;
                        }
                        LOGGER.debug("\u542f\u52a8TCP\u670d\u52a1\u7aef\u6210\u529f\uff1a{}", this.name);
                    }
                    this.close();
                }
                LOGGER.debug("\u542f\u52a8TCP\u670d\u52a1\u7aef\u6210\u529f\uff1a{}", this.name);
                break block8;
            }
            this.close();
        }
        return success;
    }

    public void close() {
        LOGGER.debug("\u5173\u95edTCP Server\uff1a{}", this.name);
        IoUtils.close(this.channel);
    }

    public static final void shutdown() {
        LOGGER.debug("\u5173\u95edTCP Server\u7ebf\u7a0b\u6c60", new Object[0]);
        SystemThreadContext.shutdown(GROUP);
    }

    static {
        AsynchronousChannelGroup group = null;
        try {
            ExecutorService executor = SystemThreadContext.newCacheExecutor(0, 60L, "ST-TCP-Server");
            group = AsynchronousChannelGroup.withThreadPool(executor);
        }
        catch (IOException e) {
            LOGGER.error("\u542f\u52a8TCP Server\u7ebf\u7a0b\u6c60\u5f02\u5e38", new Object[0]);
        }
        GROUP = group;
    }
}

