/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.MessageHandler;
import com.acgist.snail.net.NetException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public abstract class UdpMessageHandler
extends MessageHandler<DatagramChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpMessageHandler.class);
    protected final InetSocketAddress socketAddress;

    protected UdpMessageHandler(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    @Override
    public void handle(DatagramChannel channel) {
        this.channel = channel;
    }

    @Override
    public void send(ByteBuffer buffer, int timeout) throws NetException {
        this.send(buffer, this.remoteSocketAddress());
    }

    @Override
    public InetSocketAddress remoteSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public void close() {
        LOGGER.debug("UDP\u8fde\u63a5\u5173\u95ed\uff1a{}", this.socketAddress);
        this.close = true;
    }

    protected final void send(ByteBuffer buffer, SocketAddress socketAddress) throws NetException {
        this.check(buffer);
        try {
            int size = ((DatagramChannel)this.channel).send(buffer, socketAddress);
            if (size <= 0) {
                LOGGER.warn("UDP\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a{}-{}", socketAddress, size);
            }
        }
        catch (IOException e) {
            throw new NetException(e);
        }
    }
}

