/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net;

import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.Server;
import com.acgist.snail.net.UdpAcceptHandler;
import com.acgist.snail.utils.IoUtils;
import com.acgist.snail.utils.NetUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public abstract class UdpServer<T extends UdpAcceptHandler>
extends Server<DatagramChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpServer.class);
    private static final ExecutorService EXECUTOR = SystemThreadContext.newCacheExecutor(0, 60L, "ST-UDP-Server");
    private final T handler;
    private Selector selector;

    protected UdpServer(String name, T handler) {
        this(ADDR_LOCAL, 0, false, name, handler);
    }

    protected UdpServer(int port, String name, T handler) {
        this(ADDR_LOCAL, port, false, name, handler);
    }

    protected UdpServer(int port, boolean reuse, String name, T handler) {
        this(ADDR_LOCAL, port, reuse, name, handler);
    }

    protected UdpServer(String host, int port, boolean reuse, String name, T handler) {
        super(name);
        this.handler = handler;
        this.listen(host, port, reuse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean listen(String host, int port, boolean reuse) {
        boolean success;
        block8: {
            block6: {
                LOGGER.debug("\u542f\u52a8UDP\u670d\u52a1\u7aef\uff1a{}-{}-{}-{}", this.name, host, port, reuse);
                success = true;
                try {
                    this.channel = DatagramChannel.open(NetUtils.LOCAL_PROTOCOL_FAMILY);
                    ((DatagramChannel)this.channel).configureBlocking(false);
                    ((DatagramChannel)this.channel).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)reuse);
                    ((DatagramChannel)this.channel).bind(NetUtils.buildSocketAddress(host, port));
                    if (!success) break block6;
                }
                catch (IOException e) {
                    block7: {
                        try {
                            LOGGER.error("\u542f\u52a8UDP\u670d\u52a1\u7aef\u5f02\u5e38\uff1a{}", this.name, e);
                            success = false;
                            if (!success) break block7;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                LOGGER.debug("\u542f\u52a8UDP\u670d\u52a1\u7aef\u6210\u529f\uff1a{}", this.name);
                            } else {
                                this.close();
                            }
                            throw throwable;
                        }
                        LOGGER.debug("\u542f\u52a8UDP\u670d\u52a1\u7aef\u6210\u529f\uff1a{}", this.name);
                    }
                    this.close();
                }
                LOGGER.debug("\u542f\u52a8UDP\u670d\u52a1\u7aef\u6210\u529f\uff1a{}", this.name);
                break block8;
            }
            this.close();
        }
        return success;
    }

    protected void join(int ttl, String group) {
        if (!this.available()) {
            LOGGER.warn("UDP\u591a\u64ad\u5931\u8d25\uff1a{}-{}-{}", this.name, group, this.channel);
            return;
        }
        try {
            ((DatagramChannel)this.channel).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)ttl);
            ((DatagramChannel)this.channel).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)true);
            ((DatagramChannel)this.channel).join(InetAddress.getByName(group), NetUtils.DEFAULT_NETWORK_INTERFACE);
        }
        catch (IOException e) {
            LOGGER.debug("UDP\u591a\u64ad\u5f02\u5e38\uff1a{}-{}", this.name, group, e);
        }
    }

    protected void handle() {
        if (!this.available()) {
            LOGGER.warn("UDP\u6d88\u606f\u4ee3\u7406\u5931\u8d25\uff1a{}-{}", this.name, this.channel);
            return;
        }
        this.handler.handle((DatagramChannel)((DatagramChannel)this.channel));
        this.selector();
        EXECUTOR.submit(this::loopMessage);
    }

    private void selector() {
        try {
            this.selector = Selector.open();
            ((DatagramChannel)this.channel).register(this.selector, 1);
        }
        catch (IOException e) {
            LOGGER.error("\u6ce8\u518c\u6d88\u606f\u8bfb\u53d6\u4e8b\u4ef6\u5f02\u5e38\uff1a{}", this.name, e);
        }
    }

    private void loopMessage() {
        while (this.available()) {
            try {
                this.receive();
            }
            catch (Exception e) {
                LOGGER.error("UDP Server\u6d88\u606f\u8f6e\u8be2\u5f02\u5e38\uff1a{}", this.name, e);
            }
        }
        LOGGER.debug("UDP Server\u9000\u51fa\u6d88\u606f\u8f6e\u8be2\uff1a{}", this.name);
    }

    private void receive() throws IOException {
        if (this.selector.select() > 0) {
            Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = selectionKeys.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                if (!selectionKey.isValid() || !selectionKey.isReadable()) continue;
                ByteBuffer buffer = ByteBuffer.allocateDirect(2048);
                InetSocketAddress socketAddress = (InetSocketAddress)((DatagramChannel)this.channel).receive(buffer);
                ((UdpAcceptHandler)this.handler).receive(buffer, socketAddress);
            }
        }
    }

    public void close() {
        LOGGER.debug("\u5173\u95edUDP Server\uff1a{}", this.name);
        IoUtils.close(this.channel);
        IoUtils.close(this.selector);
    }

    public static final void shutdown() {
        LOGGER.debug("\u5173\u95edUDP Server\u7ebf\u7a0b\u6c60", new Object[0]);
        SystemThreadContext.shutdown(EXECUTOR);
    }
}

