/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.application;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.TcpClient;
import com.acgist.snail.net.application.ApplicationMessage;
import com.acgist.snail.net.application.ApplicationMessageHandler;
import com.acgist.snail.utils.NetUtils;

public final class ApplicationClient
extends TcpClient<ApplicationMessageHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationClient.class);

    private ApplicationClient() {
        super("Application Client", 5, new ApplicationMessageHandler());
    }

    public static final ApplicationClient newInstance() {
        return new ApplicationClient();
    }

    @Override
    public boolean connect() {
        return this.connect(NetUtils.LOOPBACK_HOST_ADDRESS, SystemConfig.getServicePort());
    }

    public void send(ApplicationMessage message) {
        ((ApplicationMessageHandler)this.handler).send(message);
    }

    public static final void notifyWindow() {
        try (ApplicationClient client = ApplicationClient.newInstance();){
            boolean success = client.connect();
            if (success) {
                client.send(ApplicationMessage.Type.NOTIFY.build());
                client.send(ApplicationMessage.Type.CLOSE.build());
            }
        }
    }
}

