/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.application;

import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;

public class ApplicationMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationMessage.class);
    public static final String FAIL = "fail";
    public static final String SUCCESS = "success";
    private static final String MESSAGE_TYPE = "type";
    private static final String MESSAGE_BODY = "body";
    private final Type type;
    private final String body;

    private ApplicationMessage(Type type, String body) {
        this.type = type;
        this.body = body;
    }

    public static final ApplicationMessage valueOf(String content) {
        try {
            BEncodeDecoder decoder = BEncodeDecoder.newInstance(content.strip()).next();
            if (decoder.isEmpty()) {
                return null;
            }
            String type = decoder.getString(MESSAGE_TYPE);
            String body = decoder.getString(MESSAGE_BODY);
            Type messageType = Type.of(type);
            if (messageType == null) {
                LOGGER.debug("\u7cfb\u7edf\u6d88\u606f\u7c7b\u578b\u9519\u8bef\uff1a{}", type);
                return null;
            }
            return messageType.build(body);
        }
        catch (NetException e) {
            LOGGER.error("\u8bfb\u53d6\u7cfb\u7edf\u6587\u672c\u6d88\u606f\u5f02\u5e38\uff1a{}", content, e);
            return null;
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getBody() {
        return this.body;
    }

    public String toString() {
        BEncodeEncoder encoder = BEncodeEncoder.newInstance().newMap().put(MESSAGE_TYPE, this.type.name());
        if (this.body != null) {
            encoder.put(MESSAGE_BODY, this.body);
        }
        return encoder.flush().toString();
    }

    public static enum Type {
        GUI,
        TEXT,
        CLOSE,
        NOTIFY,
        SHUTDOWN,
        TASK_NEW,
        TASK_LIST,
        TASK_START,
        TASK_PAUSE,
        TASK_DELETE,
        SHOW,
        HIDE,
        ALERT,
        NOTICE,
        MULTIFILE,
        REFRESH_TASK_LIST,
        REFRESH_TASK_STATUS,
        RESPONSE;


        public static final Type of(String name) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }

        public ApplicationMessage build() {
            return this.build(null);
        }

        public ApplicationMessage build(String body) {
            return new ApplicationMessage(this, body);
        }
    }
}

