/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.application;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.SystemContext;
import com.acgist.snail.context.TaskContext;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.gui.GuiMessage;
import com.acgist.snail.gui.event.adapter.MultifileEventAdapter;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.TcpMessageHandler;
import com.acgist.snail.net.application.ApplicationMessage;
import com.acgist.snail.net.codec.IMessageDecoder;
import com.acgist.snail.net.codec.IMessageEncoder;
import com.acgist.snail.net.codec.LineMessageCodec;
import com.acgist.snail.net.codec.StringMessageCodec;
import com.acgist.snail.utils.StringUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ApplicationMessageHandler
extends TcpMessageHandler
implements IMessageDecoder<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationMessageHandler.class);
    private final IMessageEncoder<String> messageEncoder;

    public ApplicationMessageHandler() {
        LineMessageCodec lineMessageCodec = new LineMessageCodec(this, SymbolConfig.LINE_SEPARATOR_COMPAT);
        StringMessageCodec stringMessageCodec = new StringMessageCodec(lineMessageCodec);
        this.messageDecoder = stringMessageCodec;
        this.messageEncoder = lineMessageCodec;
    }

    public void send(ApplicationMessage message) {
        try {
            this.send(message.toString());
        }
        catch (NetException e) {
            LOGGER.error("\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    @Override
    public void send(String message, String charset) throws NetException {
        super.send(this.messageEncoder.encode(message), charset);
    }

    @Override
    public void onMessage(String message) {
        if (StringUtils.isEmpty(message)) {
            LOGGER.warn("\u7cfb\u7edf\u6d88\u606f\u9519\u8bef\uff1a{}", message);
            return;
        }
        ApplicationMessage applicationMessage = ApplicationMessage.valueOf(message);
        if (applicationMessage == null) {
            LOGGER.warn("\u7cfb\u7edf\u6d88\u606f\u9519\u8bef\uff08\u683c\u5f0f\uff09\uff1a{}", message);
            return;
        }
        this.execute(applicationMessage);
    }

    private void execute(ApplicationMessage message) {
        ApplicationMessage.Type type = message.getType();
        if (type == null) {
            LOGGER.warn("\u7cfb\u7edf\u6d88\u606f\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", new Object[]{type});
            return;
        }
        LOGGER.debug("\u5904\u7406\u7cfb\u7edf\u6d88\u606f\uff1a{}", message);
        switch (type) {
            case GUI: {
                this.onGui();
                break;
            }
            case TEXT: {
                this.onText(message);
                break;
            }
            case CLOSE: {
                this.onClose();
                break;
            }
            case NOTIFY: {
                this.onNotify();
                break;
            }
            case SHUTDOWN: {
                this.onShutdown();
                break;
            }
            case TASK_NEW: {
                this.onTaskNew(message);
                break;
            }
            case TASK_LIST: {
                this.onTaskList();
                break;
            }
            case TASK_START: {
                this.onTaskStart(message);
                break;
            }
            case TASK_PAUSE: {
                this.onTaskPause(message);
                break;
            }
            case TASK_DELETE: {
                this.onTaskDelete(message);
                break;
            }
            case SHOW: {
                this.onShow();
                break;
            }
            case HIDE: {
                this.onHide();
                break;
            }
            case ALERT: {
                this.onAlert(message);
                break;
            }
            case NOTICE: {
                this.onNotice(message);
                break;
            }
            case MULTIFILE: {
                this.onMultifile(message);
                break;
            }
            case REFRESH_TASK_LIST: {
                this.onRefreshTaskList();
                break;
            }
            case REFRESH_TASK_STATUS: {
                this.onRefreshTaskStatus();
                break;
            }
            case RESPONSE: {
                this.onResponse(message);
                break;
            }
            default: {
                LOGGER.warn("\u7cfb\u7edf\u6d88\u606f\u9519\u8bef\uff08\u7c7b\u578b\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{type});
            }
        }
    }

    private void onGui() {
        boolean success = GuiContext.getInstance().extendGuiMessageHandler(this);
        if (success) {
            this.send(ApplicationMessage.Type.RESPONSE.build("success"));
        } else {
            this.send(ApplicationMessage.Type.RESPONSE.build("fail"));
        }
    }

    private void onText(ApplicationMessage message) {
        this.send(ApplicationMessage.Type.RESPONSE.build(message.getBody()));
    }

    private void onClose() {
        this.close();
    }

    private void onNotify() {
        GuiContext.getInstance().show();
    }

    private void onShutdown() {
        SystemContext.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTaskNew(ApplicationMessage message) {
        String body = message.getBody();
        try {
            BEncodeDecoder decoder = BEncodeDecoder.newInstance(body).next();
            if (decoder.isEmpty()) {
                this.send(ApplicationMessage.Type.RESPONSE.build("fail"));
                return;
            }
            String url = decoder.getString("url");
            String files = decoder.getString("files");
            ApplicationMessageHandler applicationMessageHandler = this;
            synchronized (applicationMessageHandler) {
                if (StringUtils.isNotEmpty(files)) {
                    MultifileEventAdapter.files(files);
                }
                if (StringUtils.isNotEmpty(url)) {
                    TaskContext.getInstance().download(url);
                }
            }
            this.send(ApplicationMessage.Type.RESPONSE.build("success"));
        }
        catch (DownloadException | NetException e) {
            this.send(ApplicationMessage.Type.RESPONSE.build(e.getMessage()));
        }
    }

    private void onTaskList() {
        List list = TaskContext.getInstance().allTask().stream().map(ITaskSession::toMap).collect(Collectors.toList());
        String body = BEncodeEncoder.encodeListString(list);
        this.send(ApplicationMessage.Type.RESPONSE.build(body));
    }

    private void onTaskStart(ApplicationMessage message) {
        Optional<ITaskSession> optional = this.selectTaskSession(message);
        if (optional.isEmpty()) {
            this.send(ApplicationMessage.Type.RESPONSE.build("fail"));
        } else {
            try {
                optional.get().start();
                this.send(ApplicationMessage.Type.RESPONSE.build("success"));
            }
            catch (DownloadException e) {
                this.send(ApplicationMessage.Type.RESPONSE.build(e.getMessage()));
            }
        }
    }

    private void onTaskPause(ApplicationMessage message) {
        Optional<ITaskSession> optional = this.selectTaskSession(message);
        if (optional.isEmpty()) {
            this.send(ApplicationMessage.Type.RESPONSE.build("fail"));
        } else {
            optional.get().pause();
            this.send(ApplicationMessage.Type.RESPONSE.build("success"));
        }
    }

    private void onTaskDelete(ApplicationMessage message) {
        Optional<ITaskSession> optional = this.selectTaskSession(message);
        if (optional.isEmpty()) {
            this.send(ApplicationMessage.Type.RESPONSE.build("fail"));
        } else {
            optional.get().delete();
            this.send(ApplicationMessage.Type.RESPONSE.build("success"));
        }
    }

    private void onShow() {
        GuiContext.getInstance().show();
    }

    private void onHide() {
        GuiContext.getInstance().hide();
    }

    private void onMultifile(ApplicationMessage message) {
        LOGGER.debug("\u6587\u4ef6\u9009\u62e9\uff1a{}", message.getBody());
    }

    private void onAlert(ApplicationMessage message) {
        try {
            GuiMessage guiMessage = GuiMessage.of(message);
            if (guiMessage == null) {
                LOGGER.warn("\u7a97\u53e3\u6d88\u606f\u9519\u8bef\uff1a{}", message);
                return;
            }
            GuiContext.getInstance().alert(guiMessage.title(), guiMessage.message(), guiMessage.type());
        }
        catch (PacketSizeException e) {
            LOGGER.warn("\u5904\u7406\u7a97\u53e3\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    private void onNotice(ApplicationMessage message) {
        try {
            GuiMessage guiMessage = GuiMessage.of(message);
            if (guiMessage == null) {
                LOGGER.warn("\u63d0\u793a\u6d88\u606f\u9519\u8bef\uff1a{}", message);
                return;
            }
            GuiContext.getInstance().notice(guiMessage.title(), guiMessage.message(), guiMessage.type());
        }
        catch (PacketSizeException e) {
            LOGGER.warn("\u5904\u7406\u63d0\u793a\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    private void onRefreshTaskList() {
        GuiContext.getInstance().refreshTaskList();
    }

    private void onRefreshTaskStatus() {
        GuiContext.getInstance().refreshTaskStatus(new Object[0]);
    }

    private void onResponse(ApplicationMessage message) {
        GuiContext.getInstance().response(message.getBody());
    }

    private Optional<ITaskSession> selectTaskSession(ApplicationMessage message) {
        String body = message.getBody();
        return TaskContext.getInstance().allTask().stream().filter(session -> session.getId().equals(body)).findFirst();
    }
}

