/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.codec;

import com.acgist.snail.net.NetException;
import com.acgist.snail.net.codec.IMessageDecoder;
import com.acgist.snail.net.codec.MessageCodec;
import java.net.InetSocketAddress;

public final class LineMessageCodec
extends MessageCodec<String, String> {
    private final String separator;
    private final int separatorLength;
    private final StringBuilder messageBuilder;

    public LineMessageCodec(IMessageDecoder<String> messageDecoder, String separator) {
        super(messageDecoder);
        this.separator = separator;
        this.separatorLength = separator.length();
        this.messageBuilder = new StringBuilder();
    }

    @Override
    public String encode(String message) {
        return message + this.separator;
    }

    @Override
    protected void doDecode(String message, InetSocketAddress address) throws NetException {
        this.messageBuilder.append(message);
        int index = this.messageBuilder.indexOf(this.separator);
        while (index >= 0) {
            String messageLine = this.messageBuilder.substring(0, index);
            this.doNext(messageLine, address);
            this.messageBuilder.delete(0, index + this.separatorLength);
            index = this.messageBuilder.indexOf(this.separator);
        }
    }
}

