/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.codec;

import com.acgist.snail.net.NetException;
import com.acgist.snail.net.codec.IMessageDecoder;
import com.acgist.snail.net.codec.IMessageEncoder;
import java.net.InetSocketAddress;

public abstract class MessageCodec<I, O>
implements IMessageDecoder<I>,
IMessageEncoder<I> {
    protected final IMessageDecoder<O> messageDecoder;

    protected MessageCodec(IMessageDecoder<O> messageDecoder) {
        this.messageDecoder = messageDecoder;
    }

    @Override
    public final boolean done() {
        return false;
    }

    @Override
    public final void decode(I message) throws NetException {
        this.doDecode(message, null);
    }

    @Override
    public final void decode(I message, InetSocketAddress address) throws NetException {
        this.doDecode(message, address);
    }

    protected abstract void doDecode(I var1, InetSocketAddress var2) throws NetException;

    protected void doNext(O message, InetSocketAddress address) throws NetException {
        if (address != null) {
            if (this.messageDecoder.done()) {
                this.messageDecoder.onMessage(message, address);
            } else {
                this.messageDecoder.decode(message, address);
            }
        } else if (this.messageDecoder.done()) {
            this.messageDecoder.onMessage(message);
        } else {
            this.messageDecoder.decode(message);
        }
    }

    @Override
    public final void onMessage(I message) throws NetException {
        throw new NetException("\u6d88\u606f\u5904\u7406\u5668\u4e0d\u80fd\u76f4\u63a5\u5904\u7406\u6d88\u606f");
    }

    @Override
    public final void onMessage(I message, InetSocketAddress address) throws NetException {
        throw new NetException("\u6d88\u606f\u5904\u7406\u5668\u4e0d\u80fd\u76f4\u63a5\u5904\u7406\u6d88\u606f");
    }
}

