/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.codec;

import com.acgist.snail.net.NetException;
import com.acgist.snail.net.codec.IMessageDecoder;
import com.acgist.snail.net.codec.MessageCodec;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;

public final class MultilineMessageCodec
extends MessageCodec<String, String> {
    private final String separator;
    private final String multilineRegex;
    private final StringBuilder multilineMessage;

    public MultilineMessageCodec(IMessageDecoder<String> messageDecoder, String separator, String multilineRegex) {
        super(messageDecoder);
        this.separator = separator;
        this.multilineRegex = multilineRegex;
        this.multilineMessage = new StringBuilder();
    }

    @Override
    protected void doDecode(String message, InetSocketAddress address) throws NetException {
        if (StringUtils.regex(message, this.multilineRegex, false)) {
            this.multilineMessage.append(message);
            this.doNext(this.multilineMessage.toString(), address);
            this.multilineMessage.setLength(0);
        } else {
            this.multilineMessage.append(message).append(this.separator);
        }
    }
}

