/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.ftp;

import com.acgist.snail.utils.StringUtils;

public enum CommandCode {
    DATA_CONNECTION_OPEN("125"),
    FILE_STATUS_OKAY("150"),
    SYSTEM_STATUS("211"),
    READY_FOR_NEW_USER("220"),
    FILE_ACTION_SUCCESS("226"),
    PASSIVE_MODE("227"),
    LOGIN_SUCCESS("230"),
    FILE_ACTION_PENDING("350"),
    CONNECTION_CLOSED("421"),
    NOT_SUPPORT_COMMAND("502"),
    NOT_LOGIN("530"),
    FILE_UNAVAILABLE("550");

    private final String code;

    private CommandCode(String code) {
        this.code = code;
    }

    public static final CommandCode of(String message) {
        CommandCode[] values;
        for (CommandCode commandCode : values = CommandCode.values()) {
            if (!StringUtils.startsWith(message, commandCode.code)) continue;
            return commandCode;
        }
        return null;
    }
}

