/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.ftp;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.wrapper.URIWrapper;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.TcpClient;
import com.acgist.snail.net.ftp.FtpMessageHandler;
import com.acgist.snail.utils.StringUtils;
import java.io.InputStream;
import java.util.stream.Stream;

public final class FtpClient
extends TcpClient<FtpMessageHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpClient.class);
    private static final int UNIX_LENGTH = 9;
    private static final int MS_DOS_LENGTH = 4;
    private static final int DEFAULT_PORT = 21;
    private boolean connect = false;
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private final String filePath;

    private FtpClient(String host, int port, String user, String password, String filePath) {
        super("FTP Client", 5, new FtpMessageHandler());
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.filePath = filePath;
    }

    public static final FtpClient newInstance(String host, int port, String user, String password, String filePath) {
        return new FtpClient(host, port, user, password, filePath);
    }

    public static final FtpClient newInstance(String url) {
        URIWrapper wrapper = URIWrapper.newInstance(url, 21, SystemConfig.getFtpUser(), SystemConfig.getFtpPassword()).decode();
        return FtpClient.newInstance(wrapper.getHost(), wrapper.getPort(), wrapper.getUser(), wrapper.password(), wrapper.getPath());
    }

    @Override
    public boolean connect() {
        ((FtpMessageHandler)this.handler).resetLock();
        this.connect = this.connect(this.host, this.port);
        ((FtpMessageHandler)this.handler).lock();
        if (this.connect) {
            this.login();
            if (((FtpMessageHandler)this.handler).getLogin()) {
                this.charset();
            } else {
                this.connect = false;
            }
        }
        return this.connect;
    }

    public InputStream download() throws NetException {
        return this.download(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream download(Long downloadSize) throws NetException {
        this.checkConnect();
        FtpClient ftpClient = this;
        synchronized (ftpClient) {
            this.command("PASV");
            this.command("TYPE I");
            if (downloadSize != null && downloadSize > 0L) {
                this.command("REST " + downloadSize);
            }
            this.command("RETR " + this.filePath);
            InputStream input = ((FtpMessageHandler)this.handler).getInputStream();
            if (input == null) {
                throw new NetException(this.failMessage("\u6253\u5f00FTP\u6587\u4ef6\u6d41\u5931\u8d25"));
            }
            return input;
        }
    }

    public Long size() throws NetException {
        this.checkConnect();
        FtpClient ftpClient = this;
        synchronized (ftpClient) {
            this.command("PASV");
            this.command("TYPE A");
            this.command("LIST " + this.filePath);
            InputStream inputStream = ((FtpMessageHandler)this.handler).getInputStream();
            String message = StringUtils.ofInputStream(inputStream, ((FtpMessageHandler)this.handler).getCharset());
            if (message == null) {
                throw new NetException(this.failMessage("\u672a\u77e5\u9519\u8bef"));
            }
            String[] messages = (String[])Stream.of(message.split(SymbolConfig.Symbol.SPACE.toString())).map(String::trim).filter(StringUtils::isNotEmpty).toArray(String[]::new);
            if (messages.length == 4) {
                return Long.valueOf(messages[2]);
            }
            if (messages.length == 9) {
                return Long.valueOf(messages[4]);
            }
            throw new NetException("\u8bfb\u53d6FTP\u6587\u4ef6\u5927\u5c0f\u5931\u8d25");
        }
    }

    public boolean range() throws NetException {
        this.checkConnect();
        return ((FtpMessageHandler)this.handler).getRange();
    }

    @Override
    public void close() {
        if (this.connect) {
            this.command("QUIT", false);
        }
        this.connect = false;
        super.close();
    }

    private void login() {
        this.command("USER " + this.user);
        this.command("PASS " + this.password);
    }

    private void charset() {
        this.command("FEAT");
        if ("UTF-8".equals(((FtpMessageHandler)this.handler).getCharset())) {
            this.command("OPTS UTF8 ON");
        }
    }

    private void command(String command) {
        this.command(command, true);
    }

    private void command(String command, boolean lock) {
        try {
            LOGGER.debug("\u53d1\u9001FTP\u547d\u4ee4\uff1a{}", command);
            if (lock) {
                ((FtpMessageHandler)this.handler).resetLock();
                this.send(command);
                ((FtpMessageHandler)this.handler).lock();
            } else {
                this.send(command);
            }
        }
        catch (NetException e) {
            LOGGER.error("\u53d1\u9001FTP\u547d\u4ee4\u5f02\u5e38\uff1a{}", command, e);
        }
    }

    private void checkConnect() throws NetException {
        if (!this.connect) {
            throw new NetException(this.failMessage("FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25"));
        }
    }

    private String failMessage(String defaultMessage) {
        return ((FtpMessageHandler)this.handler).getFailMessage(defaultMessage);
    }
}

