/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.ftp;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.TcpMessageHandler;
import com.acgist.snail.net.codec.IMessageDecoder;
import com.acgist.snail.net.codec.IMessageEncoder;
import com.acgist.snail.net.codec.LineMessageCodec;
import com.acgist.snail.net.codec.MultilineMessageCodec;
import com.acgist.snail.net.codec.StringMessageCodec;
import com.acgist.snail.net.ftp.CommandCode;
import com.acgist.snail.utils.IoUtils;
import com.acgist.snail.utils.NetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FtpMessageHandler
extends TcpMessageHandler
implements IMessageDecoder<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpMessageHandler.class);
    private static final String MULTILINE_REGEX = "\\d{3} .*";
    private boolean login = false;
    private boolean range = false;
    private String charset = "GBK";
    private String failMessage;
    private Socket inputSocket;
    private InputStream inputStream;
    private final IMessageEncoder<String> messageEncoder;
    private final AtomicBoolean lock = new AtomicBoolean(false);

    public FtpMessageHandler() {
        MultilineMessageCodec multilineMessageCodec = new MultilineMessageCodec(this, SymbolConfig.LINE_SEPARATOR_COMPAT, MULTILINE_REGEX);
        LineMessageCodec lineMessageCodec = new LineMessageCodec(multilineMessageCodec, SymbolConfig.LINE_SEPARATOR_COMPAT);
        StringMessageCodec stringMessageCodec = new StringMessageCodec(lineMessageCodec);
        this.messageDecoder = stringMessageCodec;
        this.messageEncoder = lineMessageCodec;
    }

    @Override
    public void send(String message) throws NetException {
        super.send(this.messageEncoder.encode(message), this.charset);
    }

    @Override
    public void onMessage(String message) {
        CommandCode code = CommandCode.of(message);
        if (code == null) {
            LOGGER.debug("\u6ca1\u6709\u9002\u914dFTP\u6d88\u606f\uff1a{}", message);
        } else {
            LOGGER.debug("\u5904\u7406FTP\u6d88\u606f\uff1a{}", message);
            switch (code) {
                case DATA_CONNECTION_OPEN: 
                case FILE_STATUS_OKAY: {
                    this.openInputStream();
                    break;
                }
                case SYSTEM_STATUS: {
                    this.systemStatus(message);
                    break;
                }
                case READY_FOR_NEW_USER: {
                    this.readyForNewUser(message);
                    break;
                }
                case FILE_ACTION_SUCCESS: {
                    this.fileActionSuccess(message);
                    break;
                }
                case PASSIVE_MODE: {
                    this.passiveMode(message);
                    break;
                }
                case LOGIN_SUCCESS: {
                    this.loginSuccess();
                    break;
                }
                case FILE_ACTION_PENDING: {
                    this.fileActionPending();
                    break;
                }
                case CONNECTION_CLOSED: {
                    this.connectionClosed();
                    break;
                }
                case NOT_SUPPORT_COMMAND: {
                    this.notSupportCommand(message);
                    break;
                }
                case NOT_LOGIN: {
                    this.notLogin();
                    break;
                }
                case FILE_UNAVAILABLE: {
                    this.fileUnavailable();
                    break;
                }
                default: {
                    LOGGER.warn("\u6ca1\u6709\u9002\u914dFTP\u6d88\u606f\uff1a{} - {}", new Object[]{code, message});
                }
            }
        }
        this.unlock();
    }

    public boolean getLogin() {
        return this.login;
    }

    public boolean getRange() {
        return this.range;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getFailMessage(String defaultMessage) {
        if (this.failMessage == null) {
            return defaultMessage;
        }
        return this.failMessage;
    }

    public InputStream getInputStream() throws NetException {
        if (this.inputStream == null) {
            throw new NetException(this.getFailMessage("\u672a\u77e5\u9519\u8bef"));
        }
        return this.inputStream;
    }

    private void release() {
        IoUtils.close(this.inputStream);
        IoUtils.close(this.inputSocket);
    }

    @Override
    public void close() {
        this.release();
        super.close();
    }

    public void resetLock() {
        this.lock.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        if (!this.lock.get()) {
            AtomicBoolean atomicBoolean = this.lock;
            synchronized (atomicBoolean) {
                if (!this.lock.get()) {
                    try {
                        this.lock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        AtomicBoolean atomicBoolean = this.lock;
        synchronized (atomicBoolean) {
            this.lock.set(true);
            this.lock.notifyAll();
        }
    }

    private void openInputStream() {
        if (this.inputSocket == null) {
            this.failMessage = "\u6ca1\u6709\u5207\u6362\u88ab\u52a8\u6a21\u5f0f";
        } else {
            IoUtils.close(this.inputStream);
            try {
                this.inputStream = this.inputSocket.getInputStream();
            }
            catch (IOException e) {
                this.failMessage = "\u6253\u5f00\u8f93\u5165\u6d41\u5931\u8d25";
                LOGGER.error("\u6253\u5f00\u8f93\u5165\u6d41\u5f02\u5e38", e);
            }
        }
    }

    private void systemStatus(String message) {
        if (message.toUpperCase().contains("UTF-8")) {
            this.charset = "UTF-8";
            LOGGER.debug("\u8bbe\u7f6eFTP\u7f16\u7801\uff1a{}", this.charset);
        }
    }

    private void readyForNewUser(String message) {
        LOGGER.debug("\u51c6\u5907\u8fce\u63a5\u65b0\u7684\u7528\u6237\uff1a{}", message);
    }

    private void fileActionSuccess(String message) {
        LOGGER.debug("\u6587\u4ef6\u64cd\u4f5c\u6210\u529f\uff1a{}", message);
    }

    private void passiveMode(String message) {
        this.release();
        int opening = message.indexOf(SymbolConfig.Symbol.OPEN_PARENTHESIS.toChar());
        int closing = message.indexOf(SymbolConfig.Symbol.CLOSE_PARENTHESIS.toChar(), opening + 1);
        if (opening >= 0 && closing > opening) {
            String data = message.substring(opening + 1, closing);
            StringTokenizer tokenizer = new StringTokenizer(data, SymbolConfig.Symbol.COMMA.toString());
            String host = SymbolConfig.Symbol.DOT.join(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
            int port = (Integer.parseInt(tokenizer.nextToken()) << 8) + Integer.parseInt(tokenizer.nextToken());
            try {
                this.inputSocket = new Socket();
                this.inputSocket.setSoTimeout(30000);
                this.inputSocket.connect(NetUtils.buildSocketAddress(host, port), 5000);
            }
            catch (IOException e) {
                this.failMessage = "\u6253\u5f00\u8f93\u5165\u6d41Socket\u5931\u8d25";
                LOGGER.error("\u6253\u5f00\u8f93\u5165\u6d41Socket\u5f02\u5e38\uff1a{} - {}", host, port, e);
            }
        }
    }

    private void loginSuccess() {
        this.login = true;
    }

    private void fileActionPending() {
        this.range = true;
    }

    private void connectionClosed() {
        this.failMessage = "\u6253\u5f00\u8fde\u63a5\u5931\u8d25";
    }

    private void notSupportCommand(String message) {
        LOGGER.debug("\u4e0d\u652f\u6301\u7684\u547d\u4ee4\uff1a{}", message);
    }

    private void notLogin() {
        this.login = false;
        this.failMessage = "\u6ca1\u6709\u767b\u5f55";
    }

    private void fileUnavailable() {
        this.failMessage = "\u6587\u4ef6\u65e0\u6548";
    }
}

