/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.hls;

import com.acgist.snail.config.DownloadConfig;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.wrapper.HttpHeaderWrapper;
import com.acgist.snail.downloader.Downloader;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.hls.HlsSession;
import com.acgist.snail.net.http.HttpClient;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.IoUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class HlsClient
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HlsClient.class);
    private final String link;
    private final String path;
    private long size;
    private boolean range;
    private volatile boolean completed;
    private final HlsSession hlsSession;
    private ReadableByteChannel input;
    private WritableByteChannel output;
    private final ThreadLocal<ByteBuffer> threadLocal;

    public HlsClient(String link, ITaskSession taskSession, HlsSession hlsSession, ThreadLocal<ByteBuffer> threadLocal) {
        this.link = link;
        this.path = FileUtils.file(taskSession.getFile(), FileUtils.fileName(link));
        this.range = false;
        this.completed = false;
        this.hlsSession = hlsSession;
        this.threadLocal = threadLocal;
    }

    @Override
    public void run() {
        if (!this.downloadable()) {
            LOGGER.debug("HLS\u4efb\u52a1\u4e0d\u80fd\u4e0b\u8f7d\uff1a{}", this.link);
            return;
        }
        LOGGER.debug("HLS\u4efb\u52a1\u4e0b\u8f7d\u6587\u4ef6\uff1a{}", this.link);
        long downloadSize = FileUtils.fileSize(this.path);
        this.completed = this.checkCompleted(downloadSize);
        if (this.completed) {
            LOGGER.debug("HLS\u6587\u4ef6\u6821\u9a8c\u6210\u529f\uff1a{}", this.link);
        } else {
            int length = 0;
            ByteBuffer buffer = this.threadLocal.get();
            buffer.clear();
            try {
                this.buildInput(downloadSize);
                this.buildOutput();
                if (!this.range) {
                    downloadSize = 0L;
                }
                while (this.downloadable()) {
                    length = this.input.read(buffer);
                    if (length >= 0) {
                        buffer.flip();
                        this.output.write(buffer);
                        buffer.compact();
                        downloadSize += (long)length;
                        this.hlsSession.download(length);
                    }
                    if (!Downloader.checkFinish(length, downloadSize, this.size)) continue;
                    this.completed = true;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("HLS\u4efb\u52a1\u4e0b\u8f7d\u5f02\u5e38\uff1a{}", this.link, e);
            }
        }
        this.release();
        if (this.completed) {
            LOGGER.debug("HLS\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210\uff1a{}", this.link);
            this.hlsSession.remove(this);
            this.hlsSession.downloadSize(downloadSize);
            this.hlsSession.checkCompletedAndUnlock();
        } else {
            LOGGER.debug("HLS\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff08\u91cd\u65b0\u4e0b\u8f7d\uff09\uff1a{}", this.link);
            this.hlsSession.download(this);
        }
    }

    private boolean downloadable() {
        return !this.completed && this.hlsSession.downloadable();
    }

    private boolean checkCompleted(long downloadSize) {
        if (this.completed) {
            return this.completed;
        }
        File file = new File(this.path);
        if (!file.exists()) {
            return false;
        }
        try {
            HttpHeaderWrapper header = HttpClient.newInstance(this.link).head().responseHeader();
            this.size = header.fileSize();
            return this.size == downloadSize;
        }
        catch (NetException e) {
            LOGGER.error("HLS\u6587\u4ef6\u6821\u9a8c\u5f02\u5e38\uff1a{}", this.link, e);
            return false;
        }
    }

    private void buildInput(long downloadSize) throws NetException {
        HttpClient client = HttpClient.newDownloader(this.link).range(downloadSize).get();
        if (!client.downloadable()) {
            throw new NetException("HLS\u5ba2\u6237\u7aef\u8f93\u5165\u6d41\u65b0\u5efa\u5931\u8d25");
        }
        HttpHeaderWrapper headers = client.responseHeader();
        this.range = headers.range();
        this.input = Channels.newChannel(client.response());
    }

    private void buildOutput() throws NetException {
        try {
            int bufferSize = DownloadConfig.getMemoryBufferByte(this.size);
            FileOutputStream outputStream = this.range ? new FileOutputStream(this.path, true) : new FileOutputStream(this.path);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, bufferSize);
            this.output = Channels.newChannel(bufferedOutputStream);
        }
        catch (FileNotFoundException e) {
            throw new NetException("HLS\u5ba2\u6237\u7aef\u8f93\u51fa\u6d41\u65b0\u5efa\u5931\u8d25", e);
        }
    }

    public void release() {
        LOGGER.debug("HLS\u5ba2\u6237\u7aef\u91ca\u653e\uff1a{}", this.link);
        IoUtils.close(this.input);
        this.input = null;
        IoUtils.close(this.output);
        this.output = null;
    }
}

