/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.hls;

import com.acgist.snail.context.IContext;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.hls.HlsSession;
import com.acgist.snail.net.hls.M3u8;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class HlsContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(HlsContext.class);
    private static final HlsContext INSTANCE = new HlsContext();
    private final Map<String, M3u8> m3u8Mapping = new ConcurrentHashMap<String, M3u8>();
    private final Map<String, HlsSession> sessionMapping = new ConcurrentHashMap<String, HlsSession>();

    public static final HlsContext getInstance() {
        return INSTANCE;
    }

    private HlsContext() {
    }

    public void m3u8(String id, M3u8 m3u8) {
        this.m3u8Mapping.put(id, m3u8);
    }

    public HlsSession hlsSession(ITaskSession taskSession) {
        String id = taskSession.getId();
        M3u8 m3u8 = this.m3u8Mapping.get(id);
        Objects.requireNonNull(m3u8, "\u4e0b\u8f7d\u4efb\u52a1\u7f3a\u5931M3U8\u4fe1\u606f");
        return this.sessionMapping.computeIfAbsent(id, key -> HlsSession.newInstance(m3u8, taskSession));
    }

    public void remove(ITaskSession taskSession) {
        LOGGER.debug("HLS\u4efb\u52a1\u5220\u9664\u4fe1\u606f\uff1a{}", taskSession);
        String id = taskSession.getId();
        this.m3u8Mapping.remove(id);
        this.sessionMapping.remove(id);
    }
}

