/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.hls;

import com.acgist.snail.context.IStatisticsSession;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.IMultifileCompletedChecker;
import com.acgist.snail.net.hls.HlsClient;
import com.acgist.snail.net.hls.HlsContext;
import com.acgist.snail.net.hls.M3u8;
import com.acgist.snail.utils.BeanUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;

public final class HlsSession
implements IMultifileCompletedChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(HlsSession.class);
    private volatile boolean downloadable = false;
    private final M3u8 m3u8;
    private final int fileSize;
    private ExecutorService executor;
    private final AtomicLong downloadSize;
    private final ITaskSession taskSession;
    private final List<HlsClient> clients;
    private final IStatisticsSession statistics;
    private final ThreadLocal<ByteBuffer> threadLocal;

    private HlsSession(M3u8 m3u8, ITaskSession taskSession) {
        List<String> links = taskSession.multifileSelected();
        this.m3u8 = m3u8;
        this.fileSize = links.size();
        this.downloadSize = new AtomicLong();
        this.taskSession = taskSession;
        this.clients = new ArrayList<HlsClient>(this.fileSize);
        this.statistics = taskSession.getStatistics();
        this.threadLocal = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                return ByteBuffer.allocateDirect(16384);
            }
        };
        links.stream().map(link -> new HlsClient((String)link, taskSession, this, this.threadLocal)).forEach(this.clients::add);
    }

    public static final HlsSession newInstance(M3u8 m3u8, ITaskSession taskSession) {
        return new HlsSession(m3u8, taskSession);
    }

    public Cipher cipher() {
        if (this.m3u8 == null) {
            return null;
        }
        return this.m3u8.getCipher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download() {
        if (this.downloadable) {
            LOGGER.debug("\u4efb\u52a1\u5df2\u7ecf\u5f00\u59cb\u4e0b\u8f7d", new Object[0]);
            return false;
        }
        this.downloadable = true;
        int poolSize = SystemThreadContext.DEFAULT_THREAD_SIZE;
        this.executor = SystemThreadContext.newExecutor(poolSize, poolSize, 10000, 60L, "ST-HLS");
        List<HlsClient> list = this.clients;
        synchronized (list) {
            this.clients.forEach(this::download);
        }
        return this.checkCompleted();
    }

    public void download(HlsClient client) {
        if (this.downloadable) {
            this.executor.submit(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(HlsClient client) {
        List<HlsClient> list = this.clients;
        synchronized (list) {
            this.clients.remove(client);
        }
    }

    public void download(int buffer) {
        this.statistics.download(buffer);
        this.statistics.downloadLimit(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadSize(long size) {
        int downloadFileSize;
        long newDownloadSize = this.downloadSize.addAndGet(size);
        this.taskSession.setDownloadSize(newDownloadSize);
        List<HlsClient> list = this.clients;
        synchronized (list) {
            downloadFileSize = this.fileSize - this.clients.size();
        }
        long taskFileSize = newDownloadSize * (long)this.fileSize / (long)downloadFileSize;
        this.taskSession.setSize(taskFileSize);
    }

    public boolean downloadable() {
        return this.downloadable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCompleted() {
        List<HlsClient> list = this.clients;
        synchronized (list) {
            return this.clients.isEmpty();
        }
    }

    @Override
    public boolean checkCompletedAndUnlock() {
        if (this.checkCompleted()) {
            this.taskSession.unlockDownload();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        LOGGER.debug("HLS\u4efb\u52a1\u91ca\u653e\u8d44\u6e90\uff1a{}", this.taskSession);
        this.downloadable = false;
        List<HlsClient> list = this.clients;
        synchronized (list) {
            this.clients.forEach(HlsClient::release);
        }
        SystemThreadContext.shutdownNow(this.executor);
    }

    public void delete() {
        HlsContext.getInstance().remove(this.taskSession);
    }

    public String toString() {
        return BeanUtils.toString(this, this.taskSession.getName());
    }
}

