/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.hls;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.utils.BeanUtils;
import java.util.List;
import javax.crypto.Cipher;

public final class M3u8 {
    private final Type type;
    private final Cipher cipher;
    private final List<String> links;

    public M3u8(Type type, Cipher cipher, List<String> links) {
        this.type = type;
        this.cipher = cipher;
        this.links = links;
    }

    public Type getType() {
        return this.type;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public List<String> getLinks() {
        return this.links;
    }

    public String getMaxRateLink() {
        String maxRateLink = this.links.get(this.links.size() - 1);
        return maxRateLink.replace(SymbolConfig.Symbol.BACKSLASH.toChar(), SymbolConfig.Symbol.SLASH.toChar());
    }

    public String toString() {
        return BeanUtils.toString(this, new Object[]{this.type, this.cipher, this.links});
    }

    public static enum Type {
        FILE,
        M3U8,
        STREAM;

    }

    public static enum Protocol {
        NONE("NONE"),
        AES_128("AES-128"),
        SAMPLE_AES("SAMPLE-AES");

        private final String value;

        private Protocol(String value) {
            this.value = value;
        }

        public static final Protocol of(String value) {
            Protocol[] protocols;
            for (Protocol protocol : protocols = Protocol.values()) {
                if (!protocol.value.equalsIgnoreCase(value)) continue;
                return protocol;
            }
            return null;
        }
    }
}

