/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.hls;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Cipher;

public final class TsLinker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsLinker.class);
    private static final String SUFFIX = ".ts";
    private final String name;
    private final String path;
    private final Cipher cipher;
    private final List<String> links;

    private TsLinker(String name, String path, Cipher cipher, List<String> links) {
        this.name = name;
        this.path = path;
        this.cipher = cipher;
        this.links = links;
    }

    public static final TsLinker newInstance(String name, String path, Cipher cipher, List<String> links) {
        return new TsLinker(name, path, cipher, links);
    }

    public long link() {
        List files = this.links.stream().map(link -> Paths.get(this.path, FileUtils.fileName(link)).toFile()).collect(Collectors.toList());
        File target = Paths.get(this.path, this.name + SUFFIX).toFile();
        try (FileOutputStream output = new FileOutputStream(target);){
            for (File file : files) {
                LOGGER.debug("\u8fde\u63a5\u6587\u4ef6\uff1a{} - {}", file, target);
                this.link(file, output);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u6587\u4ef6\u8fde\u63a5\u5f02\u5e38", e);
        }
        return FileUtils.fileSize(target.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void link(File file, OutputStream output) throws IOException {
        int length = 0;
        byte[] bytes = new byte[16384];
        boolean crypt = this.cipher != null;
        try (FileInputStream input = new FileInputStream(file);){
            while ((length = ((InputStream)input).read(bytes)) >= 0) {
                if (crypt) {
                    byte[] decrypt = this.cipher.update(bytes, 0, length);
                    output.write(decrypt, 0, decrypt.length);
                    continue;
                }
                output.write(bytes, 0, length);
            }
        }
        finally {
            FileUtils.delete(file);
        }
    }
}

