/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.http;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.wrapper.HttpHeaderWrapper;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.utils.IoUtils;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.NumberUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public final class HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private static final String USER_AGENT;
    private final String url;
    private final HttpURLConnection httpURLConnection;
    private int code;
    private HttpHeaderWrapper httpHeaderWrapper;

    private HttpClient(String url, int connectTimeout, int receiveTimeout) throws NetException {
        this.url = url;
        this.httpURLConnection = this.buildHttpURLConnection(connectTimeout, receiveTimeout);
        this.setDefaultHeader();
    }

    public static final HttpClient newDownloader(String url) throws NetException {
        return HttpClient.newInstance(url, 5000, 30000);
    }

    public static final HttpClient newInstance(String url) throws NetException {
        return HttpClient.newInstance(url, 5000, 5000);
    }

    public static final HttpClient newInstance(String url, int connectTimeout, int receiveTimeout) throws NetException {
        return new HttpClient(url, connectTimeout, receiveTimeout);
    }

    public HttpClient useCache() {
        this.httpURLConnection.setUseCaches(true);
        return this;
    }

    public HttpClient header(String key, String value) {
        this.httpURLConnection.setRequestProperty(key, value);
        return this;
    }

    public HttpClient keepAlive() {
        return this.header("Connection", "keep-alive");
    }

    public HttpClient disableKeepAlive() {
        return this.header("Connection", "close");
    }

    public HttpClient range(long pos) {
        return this.header("Range", "bytes=" + pos + "-");
    }

    public HttpClient get() throws NetException {
        return this.execute(Method.GET, null);
    }

    public HttpClient head() throws NetException {
        return this.execute(Method.HEAD, null);
    }

    public HttpClient post(String data) throws NetException {
        this.header("Content-Type", "application/json");
        return this.execute(Method.POST, data);
    }

    public HttpClient post(Map<String, String> data) throws NetException {
        this.header("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        if (MapUtils.isEmpty(data)) {
            return this.execute(Method.POST, null);
        }
        return this.execute(Method.POST, MapUtils.toUrlQuery(data));
    }

    public HttpClient execute(Method method, String body) throws NetException {
        OutputStream output = null;
        try {
            this.httpURLConnection.setRequestMethod(method.name());
            if (method == Method.GET) {
                this.httpURLConnection.setDoOutput(false);
            } else if (method == Method.HEAD) {
                this.httpURLConnection.setDoOutput(false);
            } else if (method == Method.POST) {
                this.httpURLConnection.setDoOutput(true);
            } else {
                throw new NetException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f\uff1a" + method);
            }
            this.httpURLConnection.connect();
            if (body != null) {
                output = this.httpURLConnection.getOutputStream();
                output.write(body.getBytes());
            }
            this.code = this.httpURLConnection.getResponseCode();
        }
        catch (IOException e) {
            try {
                throw new NetException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(output);
                throw throwable;
            }
        }
        IoUtils.close(output);
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public boolean ok() {
        return 200 == this.code;
    }

    public boolean partial() {
        return 206 == this.code;
    }

    public boolean internalError() {
        return 500 == this.code;
    }

    public boolean downloadable() {
        return this.ok() || this.partial();
    }

    public InputStream response() throws NetException {
        try {
            return this.httpURLConnection.getInputStream();
        }
        catch (IOException e) {
            throw new NetException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] responseToBytes() throws NetException {
        try (InputStream input = this.response();){
            int size = input.available();
            byte[] bytes = new byte[size];
            int length = input.read(bytes);
            if (length == size) {
                byte[] byArray2 = bytes;
                return byArray2;
            }
            byte[] byArray = Arrays.copyOf(bytes, length);
            return byArray;
        }
        catch (IOException e) {
            throw new NetException(e);
        }
    }

    public String responseToString() throws NetException {
        byte[] bytes = new byte[16384];
        StringBuilder builder = new StringBuilder();
        try (InputStream input = this.response();){
            int length;
            while ((length = input.read(bytes)) >= 0) {
                builder.append(new String(bytes, 0, length));
            }
        }
        catch (IOException e) {
            throw new NetException(e);
        }
        return builder.toString();
    }

    public HttpHeaderWrapper responseHeader() {
        if (this.httpHeaderWrapper == null) {
            this.httpHeaderWrapper = HttpHeaderWrapper.newInstance(this.httpURLConnection.getHeaderFields());
        }
        return this.httpHeaderWrapper;
    }

    public HttpClient shutdown() {
        this.httpURLConnection.disconnect();
        return this;
    }

    private void setDefaultHeader() {
        this.header("Accept", "*/*");
        this.header("User-Agent", USER_AGENT);
    }

    private HttpURLConnection buildHttpURLConnection(int connectTimeout, int receiveTimeout) throws NetException {
        try {
            URL requestUrl = new URL(this.url);
            HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setReadTimeout(receiveTimeout);
            connection.setConnectTimeout(connectTimeout);
            connection.setInstanceFollowRedirects(true);
            return connection;
        }
        catch (IOException e) {
            throw new NetException(e);
        }
    }

    private static final SSLContext buildSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new X509TrustManager[]{SnailTrustManager.INSTANCE}, NumberUtils.random());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LOGGER.error("\u65b0\u5efaSSLContext\u5f02\u5e38", e);
            try {
                return SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e2) {
                LOGGER.error("\u65b0\u5efaSSLContext\u5f02\u5e38", e2);
                return null;
            }
        }
    }

    static {
        StringBuilder userAgentBuilder = new StringBuilder();
        userAgentBuilder.append(SystemConfig.getNameEn()).append("/").append(SystemConfig.getVersion()).append(" (+").append(SystemConfig.getSupport()).append(")");
        USER_AGENT = userAgentBuilder.toString();
        LOGGER.debug("HTTP\u5ba2\u6237\u7aef\u4fe1\u606f\uff08User-Agent\uff09\uff1a{}", USER_AGENT);
        SSLContext sslContext = HttpClient.buildSSLContext();
        if (sslContext != null) {
            HttpsURLConnection.setDefaultHostnameVerifier(SnailHostnameVerifier.INSTANCE);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
    }

    public static enum Method {
        GET,
        HEAD,
        POST;

    }

    public static class SnailTrustManager
    implements X509TrustManager {
        private static final SnailTrustManager INSTANCE = new SnailTrustManager();

        private SnailTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (chain == null) {
                throw new CertificateException("\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25");
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (chain == null) {
                throw new CertificateException("\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25");
            }
        }
    }

    public static class SnailHostnameVerifier
    implements HostnameVerifier {
        private static final SnailHostnameVerifier INSTANCE = new SnailHostnameVerifier();

        private SnailHostnameVerifier() {
        }

        @Override
        public boolean verify(String requestHost, SSLSession remoteSslSession) {
            return requestHost.equalsIgnoreCase(remoteSslSession.getPeerHost());
        }
    }
}

