/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.stun;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.IContext;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NatContext;
import com.acgist.snail.net.stun.StunClient;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public final class StunContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(StunContext.class);
    private static final StunContext INSTANCE = new StunContext();
    private int index = 0;
    private String server;
    private volatile boolean scheduled = false;
    private volatile boolean available = false;

    public static final StunContext getInstance() {
        return INSTANCE;
    }

    private StunContext() {
    }

    public boolean available() {
        return this.available;
    }

    public void mapping() {
        InetSocketAddress address = this.buildServerAddress();
        if (address == null) {
            LOGGER.warn("STUN\u7aef\u53e3\u6620\u5c04\u5730\u5740\u65e0\u6548", new Object[0]);
            return;
        }
        StunClient.newInstance(address).mapping();
    }

    public void mapping(String externalIPAddress, int port) {
        if (!this.available || port != SystemConfig.getTorrentPortExt() || !StringUtils.equals(externalIPAddress, SystemConfig.getExternalIPAddress())) {
            LOGGER.debug("STUN\u7aef\u53e3\u6620\u5c04\uff1a{} - {}", externalIPAddress, port);
            this.available = true;
            PeerConfig.enableNat();
            SystemConfig.setTorrentPortExt(port);
            SystemConfig.setExternalIPAddress(externalIPAddress);
            NodeContext.getInstance().buildNodeId(externalIPAddress);
            NatContext.getInstance().unlock();
        } else {
            LOGGER.debug("STUN\u7aef\u53e3\u6620\u5c04\uff08\u6ca1\u6709\u53d8\u5316\uff09\uff1a{} - {}", externalIPAddress, port);
        }
        if (!this.scheduled) {
            this.scheduled = true;
            int interval = SystemConfig.getStunInterval();
            LOGGER.debug("\u542f\u52a8STUN\u7aef\u53e3\u6620\u5c04\u5b9a\u65f6\u670d\u52a1\uff1a{}", interval);
            SystemThreadContext.scheduledAtFixedRate(interval, interval, TimeUnit.SECONDS, this::mapping);
        }
    }

    private InetSocketAddress buildServerAddress() {
        String server = SystemConfig.getStunServer();
        if (StringUtils.isEmpty(server)) {
            LOGGER.warn("STUN\u670d\u52a1\u5668\u5217\u8868\u683c\u5f0f\u9519\u8bef\uff1a{}", server);
            return null;
        }
        String[] servers = SymbolConfig.Symbol.COMMA.split(server);
        if (!this.available) {
            int index = Math.abs(this.index++ % servers.length);
            this.server = servers[index];
        }
        return this.buildServerAddress(this.server);
    }

    private InetSocketAddress buildServerAddress(String server) {
        LOGGER.debug("STUN\u670d\u52a1\u5668\u5730\u5740\uff1a{}", server);
        String[] args = SymbolConfig.Symbol.COLON.split(server);
        int argLength = args.length;
        String lastArg = args[argLength - 1];
        if (argLength == 0) {
            LOGGER.warn("STUN\u670d\u52a1\u5668\u683c\u5f0f\u9519\u8bef\uff1a{}", server);
            return null;
        }
        if (argLength == 1) {
            return NetUtils.buildSocketAddress(lastArg, 3478);
        }
        if (StringUtils.isNumeric(lastArg)) {
            return NetUtils.buildSocketAddress(args[argLength - 2], Integer.parseInt(lastArg));
        }
        return NetUtils.buildSocketAddress(lastArg, 3478);
    }
}

