/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.stun;

import com.acgist.snail.config.StunConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.UdpMessageHandler;
import com.acgist.snail.net.stun.StunContext;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.ByteUtils;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.NumberUtils;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public final class StunMessageHandler
extends UdpMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StunMessageHandler.class);
    private static final short STUN_ATTRIBUTE_PADDING_LENGTH = 4;

    public StunMessageHandler() {
        this(null);
    }

    public StunMessageHandler(InetSocketAddress socketAddress) {
        super(socketAddress);
    }

    @Override
    public void onReceive(ByteBuffer buffer, InetSocketAddress socketAddress) throws NetException {
        short type = buffer.getShort();
        StunConfig.MessageType messageType = StunConfig.MessageType.of(type);
        if (messageType == null) {
            LOGGER.warn("\u5904\u7406STUN\u6d88\u606f\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", type);
            return;
        }
        short length = buffer.getShort();
        PacketSizeException.verify(length);
        int magicCookie = buffer.getInt();
        if (magicCookie != 554869826) {
            LOGGER.warn("\u5904\u7406STUN\u6d88\u606f\u9519\u8bef\uff08MAGIC COOKIE\uff09\uff1a{}", magicCookie);
            return;
        }
        byte[] transactionId = new byte[12];
        buffer.get(transactionId);
        switch (messageType) {
            case RESPONSE_SUCCESS: 
            case RESPONSE_ERROR: {
                this.loopResponseAttribute(buffer);
                break;
            }
            default: {
                LOGGER.warn("\u5904\u7406STUN\u6d88\u606f\u9519\u8bef\uff08\u7c7b\u578b\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{messageType});
            }
        }
    }

    private void loopResponseAttribute(ByteBuffer buffer) throws PacketSizeException {
        boolean more = true;
        while (more && buffer.hasRemaining()) {
            more = this.onResponseAttribute(buffer);
        }
    }

    private boolean onResponseAttribute(ByteBuffer buffer) throws PacketSizeException {
        if (buffer.remaining() < 4) {
            LOGGER.warn("\u5904\u7406STUN\u6d88\u606f-\u5c5e\u6027\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", buffer);
            return false;
        }
        short typeId = buffer.getShort();
        StunConfig.AttributeType attributeType = StunConfig.AttributeType.of(typeId);
        if (attributeType == null) {
            LOGGER.warn("\u5904\u7406STUN\u6d88\u606f-\u5c5e\u6027\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{} - {}", typeId, buffer);
            return false;
        }
        short length = (short)NumberUtils.ceilMult(buffer.getShort(), 4);
        PacketSizeException.verify(length);
        if (buffer.remaining() < length) {
            LOGGER.warn("\u5904\u7406STUN\u6d88\u606f-\u5c5e\u6027\u9519\u8bef\uff08\u5269\u4f59\u957f\u5ea6\uff09\uff1a{} - {}", length, buffer);
            return false;
        }
        LOGGER.debug("\u5904\u7406STUN\u6d88\u606f-\u5c5e\u6027\uff1a{} - {}", new Object[]{attributeType, length});
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        ByteBuffer message = ByteBuffer.wrap(bytes);
        return switch (attributeType) {
            case StunConfig.AttributeType.MAPPED_ADDRESS -> this.mappedAddress(message);
            case StunConfig.AttributeType.XOR_MAPPED_ADDRESS -> this.xorMappedAddress(message);
            case StunConfig.AttributeType.ERROR_CODE -> this.errorCode(message);
            default -> {
                LOGGER.warn("\u5904\u7406STUN\u6d88\u606f-\u5c5e\u6027\u9519\u8bef\uff08\u7c7b\u578b\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{attributeType});
                yield true;
            }
        };
    }

    public void changeRequest() {
        byte[] data = new byte[]{0, 0, 0, 0};
        this.pushBindingMessage(StunConfig.MessageType.REQUEST, StunConfig.AttributeType.CHANGE_REQUEST, data);
    }

    private boolean mappedAddress(ByteBuffer buffer) {
        String ipExt;
        if (buffer.remaining() < 8) {
            LOGGER.warn("\u5904\u7406STUN\u6d88\u606f-MAPPED_ADDRESS\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", buffer);
            return false;
        }
        byte header = buffer.get();
        byte family = buffer.get();
        short port = buffer.getShort();
        int portExt = NetUtils.portToInt(port);
        if (family == 1) {
            int ip = buffer.getInt();
            ipExt = NetUtils.intToIP(ip);
        } else {
            byte[] bytes = NetUtils.bufferToIPv6(buffer);
            ipExt = NetUtils.bytesToIP(bytes);
        }
        LOGGER.debug("\u5904\u7406STUN\u6d88\u606f-MAPPED_ADDRESS\uff1a{} - {} - {} - {}", header, family, portExt, ipExt);
        StunContext.getInstance().mapping(ipExt, portExt);
        return true;
    }

    private boolean xorMappedAddress(ByteBuffer buffer) {
        String ipExt;
        if (buffer.remaining() < 8) {
            LOGGER.warn("\u5904\u7406STUN\u6d88\u606f-XOR_MAPPED_ADDRESS\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", buffer);
            return false;
        }
        byte header = buffer.get();
        byte family = buffer.get();
        short port = buffer.getShort();
        short portValue = (short)(port ^ 0x2112);
        int portExt = NetUtils.portToInt(portValue);
        if (family == 1) {
            int ip = buffer.getInt();
            int ipValue = ip ^ 0x2112A442;
            ipExt = NetUtils.intToIP(ipValue);
        } else {
            byte[] source = NetUtils.bufferToIPv6(buffer);
            ByteBuffer target = ByteBuffer.allocate(16);
            target.putInt(554869826);
            target.putInt(554869826);
            target.putInt(554869826);
            target.putInt(554869826);
            byte[] result = ArrayUtils.xor(source, target.array());
            ipExt = NetUtils.bytesToIP(result);
        }
        LOGGER.debug("\u5904\u7406STUN\u6d88\u606f-XOR_MAPPED_ADDRESS\uff1a{} - {} - {} - {}", header, family, portExt, ipExt);
        StunContext.getInstance().mapping(ipExt, portExt);
        return true;
    }

    private boolean errorCode(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            LOGGER.warn("\u5904\u7406STUN\u6d88\u606f-ERROR_CODE\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", buffer);
            return false;
        }
        buffer.getShort();
        byte clazz = (byte)(buffer.get() & 7);
        byte number = buffer.get();
        String message = ByteUtils.remainingToString(buffer);
        LOGGER.warn("\u5904\u7406STUN\u6d88\u606f-ERROR_CODE\uff1a{} - {} - {}", clazz, number, message);
        return true;
    }

    private void pushBindingMessage(StunConfig.MessageType messageType, StunConfig.AttributeType attributeType, byte[] value) {
        byte[] message = this.buildBindingMessage(messageType, this.buildAttributeMessage(attributeType, value));
        try {
            this.send(message);
        }
        catch (NetException e) {
            LOGGER.error("STUN\u7ed1\u5b9a\u6d88\u606f\u53d1\u9001\u5f02\u5e38", e);
        }
    }

    private byte[] buildBindingMessage(StunConfig.MessageType messageType, byte[] message) {
        return this.buildMessage(StunConfig.MethodType.BINDING, messageType, message);
    }

    private byte[] buildMessage(StunConfig.MethodType methodType, StunConfig.MessageType messageType, byte[] message) {
        ByteBuffer buffer = ByteBuffer.allocate(20 + message.length);
        buffer.putShort(messageType.of(methodType));
        buffer.putShort((short)message.length);
        buffer.putInt(554869826);
        buffer.put(ArrayUtils.random(12));
        buffer.put(message);
        return buffer.array();
    }

    private byte[] buildAttributeMessage(StunConfig.AttributeType attributeType, byte[] value) {
        short valueLength = (short)(value == null ? 0 : value.length);
        int length = NumberUtils.ceilMult(4 + valueLength, 4);
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.putShort(attributeType.getId());
        buffer.putShort(valueLength);
        if (valueLength > 0) {
            buffer.put(value);
        }
        return buffer.array();
    }
}

