/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.net.DownloadException;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.Base32Utils;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.DigestUtils;
import com.acgist.snail.utils.PeerUtils;
import com.acgist.snail.utils.StringUtils;
import java.io.Serializable;

public final class InfoHash
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int size;
    private byte[] info;
    private final byte[] infoHash;
    private final String infoHashHex;
    private final String infoHashUrl;

    private InfoHash(byte[] infoHash) {
        this.infoHash = infoHash;
        this.infoHashHex = StringUtils.hex(this.infoHash);
        this.infoHashUrl = PeerUtils.urlEncode(this.infoHash);
    }

    public static final InfoHash newInstance(byte[] data) {
        InfoHash infoHash = new InfoHash(DigestUtils.sha1(data));
        infoHash.info = data;
        infoHash.size = data.length;
        return infoHash;
    }

    public static final InfoHash newInstance(String hash) throws DownloadException {
        if (StringUtils.isEmpty(hash)) {
            throw new DownloadException("\u4e0d\u652f\u6301\u7684Hash\uff1a" + hash);
        }
        if (Protocol.Type.verifyMagnetHash40(hash = hash.strip())) {
            return new InfoHash(StringUtils.unhex(hash));
        }
        if (Protocol.Type.verifyMagnetHash32(hash)) {
            return new InfoHash(Base32Utils.decode(hash));
        }
        throw new DownloadException("\u4e0d\u652f\u6301\u7684Hash\uff1a" + hash);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public byte[] getInfo() {
        return this.info;
    }

    public void setInfo(byte[] info) {
        this.info = info;
    }

    public byte[] getInfoHash() {
        return this.infoHash;
    }

    public String getInfoHashHex() {
        return this.infoHashHex;
    }

    public String getInfoHashUrl() {
        return this.infoHashUrl;
    }

    public String toString() {
        return BeanUtils.toString(this, this.infoHashHex);
    }
}

