/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.TorrentInfo;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Torrent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ATTR_COMMENT = "comment";
    public static final String ATTR_COMMENT_UTF8 = "comment.utf-8";
    public static final String ATTR_ENCODING = "encoding";
    public static final String ATTR_CREATED_BY = "created by";
    public static final String ATTR_CREATION_DATE = "creation date";
    public static final String ATTR_ANNOUNCE = "announce";
    public static final String ATTR_ANNOUNCE_LIST = "announce-list";
    public static final String ATTR_INFO = "info";
    public static final String ATTR_NODES = "nodes";
    private static final int NODE_LIST_LENGTH = 2;
    private String comment;
    private String commentUtf8;
    private String encoding;
    private String createdBy;
    private Long creationDate;
    private String announce;
    private List<String> announceList;
    private TorrentInfo info;
    private Map<String, Integer> nodes;
    private transient InfoHash infoHash;

    protected Torrent() {
    }

    public static final Torrent valueOf(BEncodeDecoder decoder) {
        Objects.requireNonNull(decoder, "\u79cd\u5b50\u4fe1\u606f\u4e3a\u7a7a");
        Torrent torrent = new Torrent();
        String encoding = decoder.getString(ATTR_ENCODING);
        torrent.setEncoding(encoding);
        torrent.setComment(decoder.getString(ATTR_COMMENT, encoding));
        torrent.setCommentUtf8(decoder.getString(ATTR_COMMENT_UTF8));
        torrent.setCreatedBy(decoder.getString(ATTR_CREATED_BY));
        torrent.setCreationDate(decoder.getLong(ATTR_CREATION_DATE));
        torrent.setAnnounce(decoder.getString(ATTR_ANNOUNCE));
        torrent.setAnnounceList(Torrent.readAnnounceList(decoder.getList(ATTR_ANNOUNCE_LIST)));
        torrent.setInfo(TorrentInfo.valueOf(decoder.getMap(ATTR_INFO), encoding));
        torrent.setNodes(Torrent.readNodes(decoder.getList(ATTR_NODES)));
        return torrent;
    }

    public String name() {
        String name = this.info.getNameUtf8();
        if (StringUtils.isEmpty(name)) {
            name = this.info.getName();
        }
        return name;
    }

    public InfoHash infoHash() {
        return this.infoHash;
    }

    public void infoHash(InfoHash infoHash) {
        this.infoHash = infoHash;
    }

    private static final List<String> readAnnounceList(List<Object> announceList) {
        if (announceList == null) {
            return new ArrayList<String>(0);
        }
        return announceList.stream().flatMap(value -> ((List)value).stream()).map(StringUtils::getString).collect(Collectors.toList());
    }

    private static final Map<String, Integer> readNodes(List<Object> nodes) {
        if (nodes == null) {
            return new LinkedHashMap<String, Integer>();
        }
        return nodes.stream().map(Torrent::readNode).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    private static Map.Entry<String, Integer> readNode(Object value) {
        List values = (List)value;
        if (values.size() == 2) {
            String host = StringUtils.getString(values.get(0));
            if (StringUtils.isNumeric(host)) {
                host = NetUtils.intToIP(Integer.parseInt(host));
            }
            Long port = (Long)values.get(1);
            return Map.entry(host, port.intValue());
        }
        return null;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCommentUtf8() {
        return this.commentUtf8;
    }

    public void setCommentUtf8(String commentUtf8) {
        this.commentUtf8 = commentUtf8;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public String getAnnounce() {
        return this.announce;
    }

    public void setAnnounce(String announce) {
        this.announce = announce;
    }

    public List<String> getAnnounceList() {
        return this.announceList;
    }

    public void setAnnounceList(List<String> announceList) {
        this.announceList = announceList;
    }

    public TorrentInfo getInfo() {
        return this.info;
    }

    public void setInfo(TorrentInfo info) {
        this.info = info;
    }

    public Map<String, Integer> getNodes() {
        return this.nodes;
    }

    public void setNodes(Map<String, Integer> nodes) {
        this.nodes = nodes;
    }

    public String toString() {
        return super.toString();
    }
}

