/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.net.UdpAcceptHandler;
import com.acgist.snail.net.UdpMessageHandler;
import com.acgist.snail.net.stun.StunMessageHandler;
import com.acgist.snail.net.torrent.dht.DhtMessageHandler;
import com.acgist.snail.net.torrent.utp.UtpContext;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public final class TorrentAcceptHandler
extends UdpAcceptHandler {
    private static final TorrentAcceptHandler INSTANCE = new TorrentAcceptHandler();
    private final UtpContext utpContext = UtpContext.getInstance();
    private final DhtMessageHandler dhtMessageHandler = new DhtMessageHandler();
    private final StunMessageHandler stunMessageHandler = new StunMessageHandler();

    public static final TorrentAcceptHandler getInstance() {
        return INSTANCE;
    }

    private TorrentAcceptHandler() {
    }

    @Override
    public void handle(DatagramChannel channel) {
        this.utpContext.handle(channel);
        this.dhtMessageHandler.handle(channel);
        this.stunMessageHandler.handle(channel);
    }

    @Override
    public UdpMessageHandler messageHandler(ByteBuffer buffer, InetSocketAddress socketAddress) {
        int magicCookie;
        byte header = buffer.get(0);
        if (100 == header) {
            return this.dhtMessageHandler;
        }
        if ((0 == header || 1 == header) && (magicCookie = buffer.getInt(4)) == 554869826) {
            return this.stunMessageHandler;
        }
        short connectionId = buffer.getShort(2);
        return this.utpContext.get(connectionId, socketAddress);
    }
}

