/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.context.IContext;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.Torrent;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class TorrentContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentContext.class);
    private static final TorrentContext INSTANCE = new TorrentContext();
    private final Map<String, TorrentSession> torrentSessions = new ConcurrentHashMap<String, TorrentSession>();

    public static final TorrentContext getInstance() {
        return INSTANCE;
    }

    private TorrentContext() {
    }

    public List<InfoHash> allInfoHash() {
        return this.torrentSessions.values().stream().map(TorrentSession::infoHash).collect(Collectors.toList());
    }

    public List<TorrentSession> allTorrentSession() {
        return this.torrentSessions.values().stream().collect(Collectors.toList());
    }

    public TorrentSession torrentSession(String infoHashHex) {
        return this.torrentSessions.get(infoHashHex);
    }

    public TorrentSession remove(String infoHashHex) {
        LOGGER.debug("\u5220\u9664BT\u4efb\u52a1\u4fe1\u606f\uff1a{}", infoHashHex);
        return this.torrentSessions.remove(infoHashHex);
    }

    public boolean exist(String infoHashHex) {
        return this.torrentSessions.containsKey(infoHashHex);
    }

    public TorrentSession newTorrentSession(String path) throws DownloadException {
        Torrent torrent = TorrentContext.loadTorrent(path);
        return this.newTorrentSession(torrent.infoHash(), torrent);
    }

    public TorrentSession newTorrentSession(String infoHashHex, String path) throws DownloadException {
        TorrentSession session = this.torrentSession(infoHashHex);
        if (session != null) {
            return session;
        }
        if (StringUtils.isEmpty(path)) {
            return this.newTorrentSession(InfoHash.newInstance(infoHashHex), null);
        }
        return this.newTorrentSession(path);
    }

    private TorrentSession newTorrentSession(InfoHash infoHash, Torrent torrent) throws DownloadException {
        if (infoHash == null) {
            throw new DownloadException("\u65b0\u5efaTorrentSession\u5931\u8d25\uff08InfoHash\u4e3a\u7a7a\uff09");
        }
        String infoHashHex = infoHash.getInfoHashHex();
        TorrentSession torrentSession = this.torrentSession(infoHashHex);
        if (torrentSession == null) {
            torrentSession = TorrentSession.newInstance(infoHash, torrent);
            this.torrentSessions.put(infoHashHex, torrentSession);
        }
        return torrentSession;
    }

    public static final Torrent loadTorrent(String path) throws DownloadException {
        File file = new File(path);
        if (!file.exists()) {
            throw new DownloadException("\u4e0d\u5b58\u5728\u7684\u79cd\u5b50\u6587\u4ef6");
        }
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            BEncodeDecoder decoder = BEncodeDecoder.newInstance(bytes).next();
            if (decoder.isEmpty()) {
                throw new DownloadException("\u79cd\u5b50\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
            }
            Torrent torrent = Torrent.valueOf(decoder);
            Map<String, Object> info = decoder.getMap("info");
            InfoHash infoHash = InfoHash.newInstance(BEncodeEncoder.encodeMap(info));
            torrent.infoHash(infoHash);
            return torrent;
        }
        catch (NetException | IOException e) {
            throw new DownloadException("\u79cd\u5b50\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", e);
        }
    }
}

