/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.net.torrent.TorrentFileMatedata;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TorrentFile
extends TorrentFileMatedata
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR = SymbolConfig.Symbol.SLASH.toString();
    public static final String PADDING_FILE_PREFIX = "_____padding_file";
    public static final String ATTR_PATH = "path";
    public static final String ATTR_PATH_UTF8 = "path.utf-8";
    private List<String> path;
    private List<String> pathUtf8;
    private transient boolean selected = false;
    private transient boolean paddingFile = false;

    protected TorrentFile() {
    }

    public static final TorrentFile valueOf(Map<?, ?> map, String encoding) {
        Objects.requireNonNull(map, "\u6587\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
        TorrentFile file = new TorrentFile();
        file.setEd2k(MapUtils.getBytes(map, "ed2k"));
        file.setLength(MapUtils.getLong(map, "length"));
        file.setFilehash(MapUtils.getBytes(map, "filehash"));
        List<Object> path = MapUtils.getList(map, ATTR_PATH);
        List<String> pathList = TorrentFile.readPath(path, encoding);
        file.setPath(pathList);
        List<Object> pathUtf8 = MapUtils.getList(map, ATTR_PATH_UTF8);
        List<String> pathUtf8List = TorrentFile.readPath(pathUtf8, "UTF-8");
        file.setPathUtf8(pathUtf8List);
        file.paddingFile = TorrentFile.readPaddingFile(pathList, pathUtf8List);
        return file;
    }

    public boolean selected() {
        return this.selected;
    }

    public void selected(boolean selected) {
        this.selected = selected;
    }

    public String path() {
        if (CollectionUtils.isNotEmpty(this.pathUtf8)) {
            return String.join((CharSequence)SEPARATOR, this.pathUtf8);
        }
        return String.join((CharSequence)SEPARATOR, this.path);
    }

    public boolean paddingFile() {
        return this.paddingFile;
    }

    public boolean notPaddingFile() {
        return !this.paddingFile();
    }

    private static final List<String> readPath(List<Object> path, String encoding) {
        if (path == null) {
            return new ArrayList<String>();
        }
        return path.stream().map(value -> StringUtils.getCharsetString(value, encoding)).collect(Collectors.toList());
    }

    private static final boolean readPaddingFile(List<String> pathList, List<String> pathUtf8List) {
        String fileName = null;
        if (CollectionUtils.isNotEmpty(pathUtf8List)) {
            fileName = pathUtf8List.get(pathUtf8List.size() - 1);
        } else if (CollectionUtils.isNotEmpty(pathList)) {
            fileName = pathList.get(pathList.size() - 1);
        }
        return fileName != null && fileName.startsWith(PADDING_FILE_PREFIX);
    }

    public List<String> getPath() {
        return this.path;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public List<String> getPathUtf8() {
        return this.pathUtf8;
    }

    public void setPathUtf8(List<String> pathUtf8) {
        this.pathUtf8 = pathUtf8;
    }

    public String toString() {
        return super.toString();
    }
}

