/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.net.torrent.TorrentFile;
import com.acgist.snail.net.torrent.TorrentFileMatedata;
import com.acgist.snail.utils.MapUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TorrentInfo
extends TorrentFileMatedata
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final byte PRIVATE_TORRENT = 1;
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NAME_UTF8 = "name.utf-8";
    public static final String ATTR_PIECES = "pieces";
    public static final String ATTR_PIECE_LENGTH = "piece length";
    public static final String ATTR_PUBLISHER = "publisher";
    public static final String ATTR_PUBLISHER_UTF8 = "publisher.utf-8";
    public static final String ATTR_PUBLISHER_URL = "publisher-url";
    public static final String ATTR_PUBLISHER_URL_UTF8 = "publisher-url.utf-8";
    public static final String ATTR_PRIVATE = "private";
    public static final String ATTR_FILES = "files";
    private String name;
    private String nameUtf8;
    private byte[] pieces;
    private Long pieceLength;
    private String publisher;
    private String publisherUtf8;
    private String publisherUrl;
    private String publisherUrlUtf8;
    private Long privateTorrent;
    private List<TorrentFile> files;

    protected TorrentInfo() {
    }

    public static final TorrentInfo valueOf(Map<String, Object> map, String encoding) {
        Objects.requireNonNull(map, "\u6587\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
        TorrentInfo info = new TorrentInfo();
        info.setName(MapUtils.getString(map, ATTR_NAME, encoding));
        info.setNameUtf8(MapUtils.getString(map, ATTR_NAME_UTF8));
        info.setEd2k(MapUtils.getBytes(map, "ed2k"));
        info.setLength(MapUtils.getLong(map, "length"));
        info.setFilehash(MapUtils.getBytes(map, "filehash"));
        info.setPieces(MapUtils.getBytes(map, ATTR_PIECES));
        info.setPieceLength(MapUtils.getLong(map, ATTR_PIECE_LENGTH));
        info.setPublisher(MapUtils.getString(map, ATTR_PUBLISHER, encoding));
        info.setPublisherUtf8(MapUtils.getString(map, ATTR_PUBLISHER_UTF8));
        info.setPublisherUrl(MapUtils.getString(map, ATTR_PUBLISHER_URL, encoding));
        info.setPublisherUrlUtf8(MapUtils.getString(map, ATTR_PUBLISHER_URL_UTF8));
        info.setPrivateTorrent(MapUtils.getLong(map, ATTR_PRIVATE));
        info.setFiles(TorrentInfo.readFiles(MapUtils.getList(map, ATTR_FILES), encoding));
        return info;
    }

    public int pieceSize() {
        return this.pieces.length / 20;
    }

    public boolean privateTorrent() {
        return this.privateTorrent != null && this.privateTorrent.byteValue() == 1;
    }

    public List<TorrentFile> files() {
        if (this.files.isEmpty()) {
            TorrentFile file = new TorrentFile();
            file.setEd2k(this.ed2k);
            file.setLength(this.length);
            file.setFilehash(this.filehash);
            if (this.name != null) {
                file.setPath(List.of(this.name));
            } else {
                file.setPath(List.of());
            }
            if (this.nameUtf8 != null) {
                file.setPathUtf8(List.of(this.nameUtf8));
            } else {
                file.setPathUtf8(List.of());
            }
            return List.of(file);
        }
        return this.files;
    }

    private static final List<TorrentFile> readFiles(List<Object> files, String encoding) {
        if (files == null) {
            return new ArrayList<TorrentFile>();
        }
        return files.stream().map(value -> (Map)value).map(value -> TorrentFile.valueOf(value, encoding)).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameUtf8() {
        return this.nameUtf8;
    }

    public void setNameUtf8(String nameUtf8) {
        this.nameUtf8 = nameUtf8;
    }

    public byte[] getPieces() {
        return this.pieces;
    }

    public void setPieces(byte[] pieces) {
        this.pieces = pieces;
    }

    public Long getPieceLength() {
        return this.pieceLength;
    }

    public void setPieceLength(Long pieceLength) {
        this.pieceLength = pieceLength;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getPublisherUtf8() {
        return this.publisherUtf8;
    }

    public void setPublisherUtf8(String publisherUtf8) {
        this.publisherUtf8 = publisherUtf8;
    }

    public String getPublisherUrl() {
        return this.publisherUrl;
    }

    public void setPublisherUrl(String publisherUrl) {
        this.publisherUrl = publisherUrl;
    }

    public String getPublisherUrlUtf8() {
        return this.publisherUrlUtf8;
    }

    public void setPublisherUrlUtf8(String publisherUrlUtf8) {
        this.publisherUrlUtf8 = publisherUrlUtf8;
    }

    public Long getPrivateTorrent() {
        return this.privateTorrent;
    }

    public void setPrivateTorrent(Long privateTorrent) {
        this.privateTorrent = privateTorrent;
    }

    public List<TorrentFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<TorrentFile> files) {
        this.files = files;
    }

    public String toString() {
        return super.toString();
    }
}

