/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.DigestUtils;
import java.util.Arrays;

public final class TorrentPiece {
    public static final int SLICE_LENGTH = 16384;
    private final long pieceLength;
    private final int index;
    private final int begin;
    private final int end;
    private final int length;
    private final byte[] data;
    private final byte[] hash;
    private final boolean verify;
    private int size;
    private int position;

    private TorrentPiece(long pieceLength, int index, int begin, int end, byte[] hash, boolean verify) {
        this.pieceLength = pieceLength;
        this.index = index;
        this.begin = begin;
        this.end = end;
        this.hash = hash;
        this.verify = verify;
        this.length = end - begin;
        this.data = new byte[this.length];
        this.size = 0;
        this.position = 0;
    }

    public static final TorrentPiece newInstance(long pieceLength, int index, int begin, int end, byte[] hash, boolean verify) {
        return new TorrentPiece(pieceLength, index, begin, end, hash, verify);
    }

    public long beginPos() {
        return this.pieceLength * (long)this.index + (long)this.begin;
    }

    public long endPos() {
        return this.beginPos() + (long)this.length;
    }

    public boolean contain(long fileBeginPos, long fileEndPos) {
        long endPos = this.endPos();
        if (endPos <= fileBeginPos) {
            return false;
        }
        long beginPos = this.beginPos();
        return beginPos < fileEndPos;
    }

    public boolean hasMoreSlice() {
        return this.position < this.length;
    }

    public boolean completed() {
        return this.size >= this.length;
    }

    public int position() {
        return this.begin + this.position;
    }

    public int length() {
        if (this.position >= this.length) {
            return 0;
        }
        int remaining = this.length - this.position;
        if (16384 > remaining) {
            this.position = this.length;
            return remaining;
        }
        this.position += 16384;
        return 16384;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(int begin, byte[] bytes) {
        TorrentPiece torrentPiece = this;
        synchronized (torrentPiece) {
            System.arraycopy(bytes, 0, this.data, begin - this.begin, bytes.length);
            this.size += bytes.length;
            return this.completed();
        }
    }

    public byte[] read(int begin, int size) {
        int endPos;
        if (begin >= this.end) {
            return null;
        }
        int end = begin + size;
        if (end <= this.begin) {
            return null;
        }
        int beginPos = 0;
        if (begin > this.begin) {
            beginPos = begin - this.begin;
        }
        if ((endPos = end - this.begin) > this.data.length) {
            endPos = this.data.length;
        }
        int length = endPos - beginPos;
        byte[] bytes = new byte[length];
        System.arraycopy(this.data, beginPos, bytes, 0, length);
        return bytes;
    }

    public boolean verify() {
        if (this.verify) {
            return Arrays.equals(DigestUtils.sha1(this.data), this.hash);
        }
        return true;
    }

    public boolean completedAndVerify() {
        return this.completed() && this.verify();
    }

    public int getIndex() {
        return this.index;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return BeanUtils.toString(this, this.index, this.begin, this.end);
    }
}

