/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.IStatisticsSession;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.ScheduledException;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.IMultifileCompletedChecker;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.Magnet;
import com.acgist.snail.net.torrent.Torrent;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentFile;
import com.acgist.snail.net.torrent.TorrentPiece;
import com.acgist.snail.net.torrent.TorrentStreamGroup;
import com.acgist.snail.net.torrent.dht.DhtLauncher;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.net.torrent.peer.PeerDownloaderGroup;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import com.acgist.snail.net.torrent.peer.PeerUploader;
import com.acgist.snail.net.torrent.peer.PeerUploaderGroup;
import com.acgist.snail.net.torrent.tracker.TrackerLauncherGroup;
import com.acgist.snail.protocol.magnet.MagnetBuilder;
import com.acgist.snail.protocol.magnet.TorrentBuilder;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.MapUtils;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class TorrentSession
implements IMultifileCompletedChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentSession.class);
    private PeerConfig.Action action;
    private volatile boolean useable = false;
    private volatile boolean uploadable = false;
    private volatile boolean downloadable = false;
    private Magnet magnet;
    private Torrent torrent;
    private InfoHash infoHash;
    private ITaskSession taskSession;
    private DhtLauncher dhtLauncher;
    private PeerUploaderGroup peerUploaderGroup;
    private PeerDownloaderGroup peerDownloaderGroup;
    private TorrentStreamGroup torrentStreamGroup;
    private TrackerLauncherGroup trackerLauncherGroup;
    private ExecutorService executor;
    private ScheduledExecutorService executorScheduled;
    private ScheduledFuture<?> pexScheduled;
    private ScheduledFuture<?> haveScheduled;
    private ScheduledFuture<?> dhtLauncherScheduled;
    private ScheduledFuture<?> peerUploaderGroupScheduled;
    private ScheduledFuture<?> peerDownloaderGroupScheduled;
    private ScheduledFuture<?> trackerLauncherGroupScheduled;

    private TorrentSession(InfoHash infoHash, Torrent torrent) throws DownloadException {
        if (infoHash == null) {
            throw new DownloadException("\u65b0\u5efaTorrentSession\u5931\u8d25\uff08InfoHash\uff09");
        }
        this.torrent = torrent;
        this.infoHash = infoHash;
    }

    public static final TorrentSession newInstance(InfoHash infoHash, Torrent torrent) throws DownloadException {
        return new TorrentSession(infoHash, torrent);
    }

    public boolean magnet(ITaskSession taskSession) throws DownloadException {
        if (this.useable) {
            LOGGER.debug("\u4efb\u52a1\u5df2\u7ecf\u5f00\u59cb\u8f6c\u6362", new Object[0]);
            return false;
        }
        this.action = PeerConfig.Action.MAGNET;
        this.taskSession = taskSession;
        if (this.checkCompleted()) {
            return true;
        }
        this.loadMagnet();
        this.loadExecutor();
        this.loadExecutorScheduled();
        this.loadTrackerLauncherGroup();
        this.loadTrackerLauncherGroupScheduled();
        this.loadDhtLauncher();
        this.loadDhtLauncherScheduled();
        this.loadPeerUploaderGroup();
        this.loadPeerUploaderGroupScheduled();
        this.loadPeerDownloaderGroup();
        this.loadPeerDownloaderGroupScheduled();
        this.useable = true;
        this.uploadable = false;
        this.downloadable = false;
        return false;
    }

    public TorrentSession upload(ITaskSession taskSession) {
        if (this.uploadable) {
            LOGGER.debug("\u4efb\u52a1\u5df2\u7ecf\u5f00\u59cb\u4e0a\u4f20", new Object[0]);
            return this;
        }
        this.taskSession = taskSession;
        this.loadExecutorScheduled();
        this.loadTorrentStreamGroup();
        this.loadPeerUploaderGroup();
        this.loadPeerUploaderGroupScheduled();
        this.useable = true;
        this.uploadable = true;
        return this;
    }

    public boolean download() throws DownloadException {
        return this.download(true);
    }

    public boolean download(boolean findPeer) throws DownloadException {
        if (this.downloadable) {
            LOGGER.debug("\u4efb\u52a1\u5df2\u7ecf\u5f00\u59cb\u4e0b\u8f7d", new Object[0]);
            return false;
        }
        if (!this.uploadable) {
            throw new DownloadException("\u8bf7\u5148\u5f00\u542f\u4efb\u52a1\u4e0a\u4f20");
        }
        this.action = PeerConfig.Action.TORRENT;
        if (this.checkCompleted()) {
            return true;
        }
        this.loadExecutor();
        boolean privateTorrent = this.privateTorrent();
        if (findPeer) {
            this.loadTrackerLauncherGroup();
            this.loadTrackerLauncherGroupScheduled();
            if (privateTorrent) {
                LOGGER.debug("\u79c1\u6709\u79cd\u5b50\uff1a\u4e0d\u52a0\u8f7dDHT\u5b9a\u65f6\u4efb\u52a1", new Object[0]);
            } else {
                this.loadDhtLauncher();
                this.loadDhtLauncherScheduled();
            }
        }
        this.loadPeerDownloaderGroup();
        this.loadPeerDownloaderGroupScheduled();
        this.loadPeerUploaderDownload();
        if (privateTorrent) {
            LOGGER.debug("\u79c1\u6709\u79cd\u5b50\uff1a\u4e0d\u52a0\u8f7dPEX\u5b9a\u65f6\u4efb\u52a1", new Object[0]);
        } else {
            this.loadPexScheduled();
        }
        this.loadHaveScheduled();
        this.downloadable = true;
        return false;
    }

    private void loadMagnet() throws DownloadException {
        this.magnet = MagnetBuilder.newInstance(this.taskSession.getUrl()).build();
    }

    private void loadExecutor() {
        this.executor = SystemThreadContext.newCacheExecutor(0, 60L, "ST-BT");
    }

    private void loadExecutorScheduled() {
        int poolSize = SystemThreadContext.threadSize(2, 4);
        this.executorScheduled = SystemThreadContext.newScheduledExecutor(poolSize, "ST-BT-Scheduled");
    }

    private void loadTorrentStreamGroup() {
        this.torrentStreamGroup = TorrentStreamGroup.newInstance(this.taskSession.getDownloadFolder().getAbsolutePath(), this.buildSelectedFiles(), this);
    }

    private void loadPeerDownloaderGroup() {
        this.peerDownloaderGroup = PeerDownloaderGroup.newInstance(this);
    }

    private void loadPeerDownloaderGroupScheduled() {
        int peerOptimizeInterval = SystemConfig.getPeerOptimizeInterval();
        this.peerDownloaderGroupScheduled = this.scheduledAtFixedDelay(0L, peerOptimizeInterval, TimeUnit.SECONDS, this.peerDownloaderGroup::optimize);
    }

    private void loadPeerUploaderGroup() {
        this.peerUploaderGroup = PeerUploaderGroup.newInstance(this);
    }

    private void loadPeerUploaderGroupScheduled() {
        int peerOptimizeInterval = SystemConfig.getPeerOptimizeInterval();
        this.peerUploaderGroupScheduled = this.scheduledAtFixedDelay(peerOptimizeInterval, peerOptimizeInterval, TimeUnit.SECONDS, this.peerUploaderGroup::optimize);
    }

    private void loadPeerUploaderDownload() {
        this.submit(this.peerUploaderGroup::download);
    }

    private void loadTrackerLauncherGroup() {
        this.trackerLauncherGroup = TrackerLauncherGroup.newInstance(this);
        this.trackerLauncherGroup.loadTracker();
    }

    private void loadTrackerLauncherGroupScheduled() {
        int trackerInterval = SystemConfig.getTrackerInterval();
        this.trackerLauncherGroupScheduled = this.scheduledAtFixedDelay(0L, trackerInterval, TimeUnit.SECONDS, this.trackerLauncherGroup::findPeer);
    }

    private void loadDhtLauncher() {
        Map<String, Integer> nodes;
        this.dhtLauncher = DhtLauncher.newInstance(this);
        if (this.action == PeerConfig.Action.TORRENT && MapUtils.isNotEmpty(nodes = this.torrent.getNodes())) {
            nodes.forEach(this.dhtLauncher::put);
        }
    }

    private void loadDhtLauncherScheduled() {
        int dhtInterval = SystemConfig.getDhtInterval();
        this.dhtLauncherScheduled = this.scheduledAtFixedDelay(dhtInterval, dhtInterval, TimeUnit.SECONDS, this.dhtLauncher);
    }

    private void loadPexScheduled() {
        int pexInterval = SystemConfig.getPexInterval();
        this.pexScheduled = this.scheduledAtFixedDelay(pexInterval, pexInterval, TimeUnit.SECONDS, () -> PeerContext.getInstance().pex(this.infoHashHex()));
    }

    private void loadHaveScheduled() {
        int haveInterval = SystemConfig.getHaveInterval();
        this.haveScheduled = this.scheduledAtFixedDelay(haveInterval, haveInterval, TimeUnit.SECONDS, () -> PeerContext.getInstance().have(this.infoHashHex()));
    }

    public void submit(Runnable runnable) {
        this.executor.submit(runnable);
    }

    public ScheduledFuture<?> scheduledAtFixedDelay(long delay, long period, TimeUnit unit, Runnable runnable) {
        ScheduledException.verify(delay);
        ScheduledException.verify(period);
        return this.executorScheduled.scheduleWithFixedDelay(runnable, delay, period, unit);
    }

    private List<TorrentFile> buildSelectedFiles() {
        List<TorrentFile> torrentFiles = this.torrent.getInfo().files();
        List<String> selectedFiles = this.taskSession.multifileSelected();
        for (TorrentFile torrentFile : torrentFiles) {
            torrentFile.selected(selectedFiles.contains(torrentFile.path()));
        }
        return torrentFiles;
    }

    @Override
    public boolean checkCompleted() {
        if (this.completed()) {
            return true;
        }
        if (this.action == PeerConfig.Action.TORRENT) {
            return this.torrentStreamGroup.completed();
        }
        return this.torrent != null;
    }

    @Override
    public boolean checkCompletedAndUnlock() {
        if (this.checkCompleted()) {
            this.taskSession.unlockDownload();
            return true;
        }
        return false;
    }

    public void releaseMagnet() {
        LOGGER.debug("Torrent\u91ca\u653e\u8d44\u6e90\uff08\u78c1\u529b\u94fe\u63a5\uff09", new Object[0]);
        this.releaseDownload();
        this.releaseUpload();
    }

    public void releaseDownload() {
        this.downloadable = false;
        LOGGER.debug("Torrent\u91ca\u653e\u8d44\u6e90\uff08\u4e0b\u8f7d\uff09", new Object[0]);
        if (this.completed()) {
            PeerContext.getInstance().uploadOnly(this.infoHashHex());
        }
        SystemThreadContext.shutdownNow(this.haveScheduled);
        SystemThreadContext.shutdownNow(this.pexScheduled);
        SystemThreadContext.shutdownNow(this.peerDownloaderGroupScheduled);
        if (this.peerDownloaderGroup != null) {
            this.peerDownloaderGroup.release();
        }
        SystemThreadContext.shutdownNow(this.dhtLauncherScheduled);
        SystemThreadContext.shutdownNow(this.trackerLauncherGroupScheduled);
        if (this.trackerLauncherGroup != null) {
            this.trackerLauncherGroup.release();
        }
        SystemThreadContext.shutdownNow(this.executor);
        if (this.torrentStreamGroup != null) {
            this.torrentStreamGroup.flush();
        }
    }

    public void releaseUpload() {
        this.useable = false;
        this.uploadable = false;
        LOGGER.debug("Torrent\u91ca\u653e\u8d44\u6e90\uff08\u4e0a\u4f20\uff09", new Object[0]);
        SystemThreadContext.shutdownNow(this.peerUploaderGroupScheduled);
        if (this.peerUploaderGroup != null) {
            this.peerUploaderGroup.release();
        }
        if (this.torrentStreamGroup != null) {
            this.torrentStreamGroup.release();
        }
        SystemThreadContext.shutdownNow(this.executorScheduled);
    }

    public void delete() {
        String infoHashHex = this.infoHashHex();
        PeerContext.getInstance().remove(infoHashHex);
        TorrentContext.getInstance().remove(infoHashHex);
    }

    public void saveTorrent() {
        String torrentFilePath = null;
        TorrentBuilder builder = TorrentBuilder.newInstance(this.infoHash, this.trackerLauncherGroup.trackers());
        try {
            torrentFilePath = builder.buildFile(this.taskSession.getDownloadFolder().getAbsolutePath());
            this.torrent = TorrentContext.loadTorrent(torrentFilePath);
            this.infoHash = this.torrent.infoHash();
        }
        catch (DownloadException | PacketSizeException e) {
            LOGGER.error("\u52a0\u8f7d\u79cd\u5b50\u5f02\u5e38\uff1a{}", torrentFilePath, e);
        }
        if (torrentFilePath == null) {
            return;
        }
        long torrentFileSize = FileUtils.fileSize(torrentFilePath);
        this.taskSession.setTorrent(torrentFilePath);
        this.taskSession.setSize(torrentFileSize);
        this.taskSession.setDownloadSize(torrentFileSize);
        this.taskSession.update();
        this.checkCompletedAndUnlock();
    }

    public void have(int index) {
        PeerContext.getInstance().have(this.infoHashHex(), index);
    }

    public String name() {
        if (this.taskSession == null) {
            if (this.torrent == null) {
                return this.infoHash.getInfoHashHex();
            }
            return this.torrent.name();
        }
        return this.taskSession.getName();
    }

    public long size() {
        return this.taskSession.getSize();
    }

    public BitSet buildPieces() {
        byte[] payload = this.taskSession.getPayload();
        if (payload == null) {
            return new BitSet(this.torrent.getInfo().pieceSize());
        }
        return BitSet.valueOf(payload);
    }

    public void updatePieces(boolean persistent) {
        byte[] payload = this.pieces().toByteArray();
        this.taskSession.setPayload(payload);
        if (persistent) {
            this.taskSession.update();
        }
    }

    public PeerConfig.Action action() {
        return this.action;
    }

    public Magnet magnet() {
        return this.magnet;
    }

    public Torrent torrent() {
        return this.torrent;
    }

    public InfoHash infoHash() {
        return this.infoHash;
    }

    public String infoHashHex() {
        return this.infoHash.getInfoHashHex();
    }

    public boolean privateTorrent() {
        if (this.torrent == null) {
            return false;
        }
        return this.torrent.getInfo().privateTorrent();
    }

    public ITaskSession taskSession() {
        return this.taskSession;
    }

    public TorrentStreamGroup torrentStreamGroup() {
        return this.torrentStreamGroup;
    }

    public boolean useable() {
        return this.useable;
    }

    public boolean uploadable() {
        return this.uploadable;
    }

    public boolean downloadable() {
        return this.downloadable;
    }

    public void downloadSize(long size) {
        this.taskSession.setDownloadSize(size);
    }

    public boolean completed() {
        return this.taskSession.statusCompleted();
    }

    public IStatisticsSession statistics() {
        return this.taskSession.getStatistics();
    }

    public int reload() {
        return this.torrentStreamGroup.reload(this.taskSession.getDownloadFolder().getAbsolutePath(), this.buildSelectedFiles());
    }

    public void piecePos(int index) {
        this.torrentStreamGroup.piecePos(index);
    }

    public TorrentPiece pick(BitSet peerPieces, BitSet suggestPieces) {
        return this.torrentStreamGroup.pick(peerPieces, suggestPieces);
    }

    public byte[] read(int index, int begin, int length) throws NetException {
        return this.torrentStreamGroup.read(index, begin, length);
    }

    public boolean write(TorrentPiece piece) {
        return this.torrentStreamGroup.write(piece);
    }

    public boolean hasPiece(int index) {
        return this.torrentStreamGroup.hasPiece(index);
    }

    public void undone(TorrentPiece piece) {
        this.torrentStreamGroup.undone(piece);
    }

    public void fullPieces(BitSet pieces) {
        this.torrentStreamGroup.fullPieces(pieces);
    }

    public void fullPieces() {
        this.torrentStreamGroup.fullPieces();
    }

    public int health() {
        return this.torrentStreamGroup.health();
    }

    public boolean verify() {
        try {
            return this.torrentStreamGroup.verify();
        }
        catch (IOException e) {
            LOGGER.error("\u6587\u4ef6\u6821\u9a8c\u5f02\u5e38", e);
            return false;
        }
    }

    public BitSet pieces() {
        return this.torrentStreamGroup.pieces();
    }

    public BitSet selectPieces() {
        return this.torrentStreamGroup.selectPieces();
    }

    public BitSet allPieces() {
        return this.torrentStreamGroup.allPieces();
    }

    public void newNode(String host, int port) {
        if (this.dhtLauncher != null) {
            this.dhtLauncher.put(host, port);
        }
    }

    public PeerUploader newPeerUploader(PeerSession peerSession, PeerSubMessageHandler peerSubMessageHandler) {
        return this.peerUploaderGroup.newPeerUploader(peerSession, peerSubMessageHandler);
    }

    public String toString() {
        return BeanUtils.toString(this, this.name());
    }
}

