/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.torrent.TorrentPiece;
import com.acgist.snail.net.torrent.TorrentStreamGroup;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.DigestUtils;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.IoUtils;
import com.acgist.snail.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public final class TorrentStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentStream.class);
    private static final String STREAM_MODE = "rw";
    private volatile boolean selected;
    private final long pieceLength;
    private final String filePath;
    private final long fileSize;
    private final long fileBeginPos;
    private final long fileEndPos;
    private final int fileBeginPieceIndex;
    private final int fileEndPieceIndex;
    private final int filePieceSize;
    private final AtomicLong fileDownloadSize;
    private final BitSet pieces;
    private final BitSet pausePieces;
    private final BitSet downloadPieces;
    private final BlockingQueue<TorrentPiece> cachePieces;
    private final RandomAccessFile fileStream;
    private final TorrentStreamGroup torrentStreamGroup;

    private TorrentStream(long pieceLength, String path, long size, long pos, boolean completed, TorrentStreamGroup torrentStreamGroup) throws DownloadException {
        this.pieceLength = pieceLength;
        this.filePath = path;
        this.fileSize = size;
        this.fileBeginPos = pos;
        this.fileEndPos = pos + size;
        this.fileBeginPieceIndex = (int)(this.fileBeginPos / this.pieceLength);
        this.fileEndPieceIndex = (int)(this.fileEndPos / this.pieceLength);
        int filePieceSize = this.fileEndPieceIndex - this.fileBeginPieceIndex;
        int endPieceSize = (int)(this.fileEndPos % this.pieceLength);
        this.filePieceSize = endPieceSize > 0 ? filePieceSize + 1 : filePieceSize;
        this.fileDownloadSize = new AtomicLong(0L);
        this.pieces = new BitSet();
        this.pausePieces = new BitSet();
        this.downloadPieces = new BitSet();
        this.cachePieces = new LinkedBlockingQueue<TorrentPiece>();
        this.fileStream = this.buildFileStream();
        this.torrentStreamGroup = torrentStreamGroup;
        this.buildPieces(completed);
        this.buildFileDownloadSize();
        if (LOGGER.isDebugEnabled()) {
            int downloadPieceSize = this.pieces.cardinality();
            LOGGER.debug("\u65b0\u5efa\u6587\u4ef6\u6d41\uff1a{}\n\u6587\u4ef6\u5927\u5c0f\uff1a{}\nPiece\u5927\u5c0f\uff1a{}\n\u6587\u4ef6\u5f00\u59cb\u504f\u79fb\uff1a{}\n\u6587\u4ef6\u7ed3\u675f\u504f\u79fb\uff1a{}\n\u6587\u4ef6Piece\u6570\u91cf\uff1a{}\n\u6587\u4ef6Piece\u5f00\u59cb\u7d22\u5f15\uff1a{}\n\u6587\u4ef6Piece\u7ed3\u675f\u7d22\u5f15\uff1a{}\n\u5df2\u7ecf\u4e0b\u8f7dPiece\u6570\u91cf\uff1a{}\n\u5269\u4f59\u4e0b\u8f7dPiece\u6570\u91cf\uff1a{}", this.filePath, this.pieceLength, this.fileSize, this.fileBeginPos, this.fileEndPos, this.filePieceSize, this.fileBeginPieceIndex, this.fileEndPieceIndex, downloadPieceSize, this.filePieceSize - downloadPieceSize);
        }
    }

    public static final TorrentStream newInstance(long pieceLength, String path, long size, long pos, boolean completed, TorrentStreamGroup torrentStreamGroup) throws DownloadException {
        return new TorrentStream(pieceLength, path, size, pos, completed, torrentStreamGroup);
    }

    private RandomAccessFile buildFileStream() throws DownloadException {
        FileUtils.buildParentFolder(this.filePath);
        try {
            return new RandomAccessFile(this.filePath, STREAM_MODE);
        }
        catch (FileNotFoundException e) {
            throw new DownloadException("\u65b0\u5efa\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + this.filePath, e);
        }
    }

    public void install() {
        this.selected = true;
    }

    public void uninstall() {
        this.selected = false;
    }

    public boolean selected() {
        return this.selected;
    }

    public boolean equalsPath(String path) {
        return StringUtils.equals(path, this.filePath);
    }

    public void buildSelectPieces(BitSet selectPieces) {
        selectPieces.set(this.fileBeginPieceIndex, this.fileEndPieceIndex + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentPiece pick(int piecePos, BitSet peerPieces, BitSet suggestPieces) {
        if (piecePos > this.fileEndPieceIndex) {
            return null;
        }
        if (peerPieces.isEmpty() && suggestPieces.isEmpty()) {
            return null;
        }
        if (this.completed()) {
            return null;
        }
        TorrentStream torrentStream = this;
        synchronized (torrentStream) {
            BitSet pickPieces = this.pickPieces(peerPieces, suggestPieces);
            int indexPos = Math.max(piecePos, this.fileBeginPieceIndex);
            int index = pickPieces.nextSetBit(indexPos);
            if (index < 0 || index > this.fileEndPieceIndex) {
                LOGGER.debug("\u9009\u62e9Piece\uff08\u6ca1\u6709\u5339\u914d\uff09\uff1a{}-{}-{}-{}", index, piecePos, this.fileBeginPieceIndex, this.fileEndPieceIndex);
                return null;
            }
            LOGGER.debug("\u9009\u62e9Piece\uff08\u9009\u4e2d\uff09\uff1a{}-{}", index, this.downloadPieces);
            this.downloadPieces.set(index);
            boolean verify = true;
            int begin = 0;
            if (index == this.fileBeginPieceIndex) {
                verify = false;
                begin = this.firstPiecePos();
            }
            int end = (int)this.pieceLength;
            if (index == this.fileEndPieceIndex) {
                verify = false;
                end = this.lastPiecePos();
            }
            byte[] hash = this.torrentStreamGroup.pieceHash(index);
            return TorrentPiece.newInstance(this.pieceLength, index, begin, end, hash, verify);
        }
    }

    private BitSet pickPieces(BitSet peerPieces, BitSet suggestPieces) {
        BitSet pickPieces = new BitSet();
        if (!suggestPieces.isEmpty()) {
            pickPieces.or(suggestPieces);
            pickPieces.andNot(this.pieces);
            pickPieces.andNot(this.pausePieces);
            pickPieces.andNot(this.downloadPieces);
        }
        if (pickPieces.isEmpty()) {
            pickPieces.or(peerPieces);
            pickPieces.andNot(this.pieces);
            pickPieces.andNot(this.pausePieces);
            pickPieces.andNot(this.downloadPieces);
        }
        if (pickPieces.isEmpty()) {
            int remainingPieceSize = this.torrentStreamGroup.remainingPieceSize();
            if (remainingPieceSize == 0) {
                LOGGER.debug("\u9009\u62e9Piece\uff1a\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210", new Object[0]);
            } else if (remainingPieceSize <= SystemConfig.getPieceRepeatSize()) {
                LOGGER.debug("\u9009\u62e9Piece\uff1a\u4efb\u52a1\u63a5\u8fd1\u5b8c\u6210", new Object[0]);
                pickPieces.or(peerPieces);
                pickPieces.andNot(this.pieces);
            } else {
                LOGGER.debug("\u9009\u62e9Piece\uff1a\u4efb\u52a1\u6b63\u5e38\u4e0b\u8f7d", new Object[0]);
                pickPieces.or(peerPieces);
                pickPieces.andNot(this.pieces);
                pickPieces.andNot(this.downloadPieces);
            }
            if (pickPieces.isEmpty()) {
                LOGGER.debug("\u9009\u62e9Piece\uff1a\u6ca1\u6709\u53ef\u7528Piece", new Object[0]);
            }
        }
        this.pausePieces.clear();
        return pickPieces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(TorrentPiece piece) {
        if (!piece.contain(this.fileBeginPos, this.fileEndPos)) {
            return false;
        }
        TorrentStream torrentStream = this;
        synchronized (torrentStream) {
            int index = piece.getIndex();
            if (this.hasPiece(index)) {
                LOGGER.debug("Piece\u5df2\u7ecf\u4e0b\u8f7d\u5b8c\u6210\uff08\u5ffd\u7565\uff09\uff1a{}", index);
                return false;
            }
            if (this.cachePieces.offer(piece)) {
                LOGGER.debug("\u4fdd\u5b58Piece\u6210\u529f\uff1a{}", index);
                this.done(index);
                this.buildFileDownloadSize();
                if (this.completed()) {
                    this.flush();
                }
                return true;
            }
            LOGGER.warn("\u4fdd\u5b58Piece\u5931\u8d25\uff1a{}", index);
            return false;
        }
    }

    public byte[] read(int index) {
        return this.read(index, (int)this.pieceLength);
    }

    public byte[] read(int index, int length) {
        return this.read(index, length, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(int index, int length, int pos) {
        TorrentStream torrentStream = this;
        synchronized (torrentStream) {
            return this.read(index, length, pos, false);
        }
    }

    private byte[] read(int index, int length, int pos, boolean ignoreHasPiece) {
        if (!ignoreHasPiece && !this.hasPiece(index)) {
            return null;
        }
        TorrentPiece cachePiece = this.cachePiece(index);
        if (cachePiece != null) {
            return cachePiece.read(pos, length);
        }
        long seek = 0L;
        long beginPos = this.pieceLength * (long)index + (long)pos;
        long endPos = beginPos + (long)length;
        if (beginPos >= this.fileEndPos) {
            return null;
        }
        if (endPos <= this.fileBeginPos) {
            return null;
        }
        if (beginPos <= this.fileBeginPos) {
            length = (int)((long)length - (this.fileBeginPos - beginPos));
        } else {
            seek = beginPos - this.fileBeginPos;
        }
        if (endPos >= this.fileEndPos) {
            length = (int)((long)length - (endPos - this.fileEndPos));
        }
        try {
            byte[] bytes = new byte[length];
            this.fileStream.seek(seek);
            this.fileStream.read(bytes);
            return bytes;
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6Piece\u5f02\u5e38\uff1a{}-{}-{}-{}", index, seek, length, pos, e);
            return null;
        }
    }

    public long downloadSize() {
        return this.fileDownloadSize.get();
    }

    private void done(int index) {
        this.pieces.set(index);
        this.downloadPieces.clear(index);
        this.torrentStreamGroup.done(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undone(TorrentPiece piece) {
        if (!piece.contain(this.fileBeginPos, this.fileEndPos)) {
            return;
        }
        TorrentStream torrentStream = this;
        synchronized (torrentStream) {
            this.pausePieces.set(piece.getIndex());
            this.downloadPieces.clear(piece.getIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completed() {
        TorrentStream torrentStream = this;
        synchronized (torrentStream) {
            return this.pieces.cardinality() >= this.filePieceSize;
        }
    }

    public void release() {
        this.flush();
        IoUtils.close(this.fileStream);
    }

    private boolean verify(int index, MessageDigest digest) {
        int pos = 0;
        int length = 0;
        boolean verify = true;
        if (index == this.fileBeginPieceIndex) {
            pos = this.firstPiecePos();
            length = this.firstPieceSize();
            verify = false;
        } else if (index == this.fileEndPieceIndex) {
            pos = 0;
            length = this.lastPieceSize();
            verify = false;
        } else {
            pos = 0;
            length = (int)this.pieceLength;
            verify = true;
        }
        byte[] bytes = this.read(index, length, pos, true);
        if (bytes == null) {
            return false;
        }
        if (verify) {
            byte[] hash = digest.digest(bytes);
            byte[] verifyHash = this.torrentStreamGroup.pieceHash(index);
            return Arrays.equals(hash, verifyHash);
        }
        return this.hasData(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify() throws IOException {
        int verifyFailCount = 0;
        boolean empty = this.fileStream.length() == 0L;
        TorrentStream torrentStream = this;
        synchronized (torrentStream) {
            MessageDigest digest = DigestUtils.sha1();
            for (int index = this.fileBeginPieceIndex; index <= this.fileEndPieceIndex; ++index) {
                if (empty) {
                    ++verifyFailCount;
                    this.verifyFail(index);
                    continue;
                }
                if (this.verify(index, digest)) {
                    this.done(index);
                    continue;
                }
                ++verifyFailCount;
                this.verifyFail(index);
            }
            this.buildFileDownloadSize();
        }
        return verifyFailCount == 0;
    }

    private void verifyFail(int index) {
        LOGGER.debug("Piece\u6821\u9a8c\u5931\u8d25\uff1a{}", index);
        this.pieces.clear(index);
        this.torrentStreamGroup.undone(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        TorrentStream torrentStream = this;
        synchronized (torrentStream) {
            ArrayList<TorrentPiece> list = new ArrayList<TorrentPiece>();
            this.cachePieces.drainTo(list);
            list.forEach(this::flush);
        }
    }

    private void flush(TorrentPiece piece) {
        int index = piece.getIndex();
        LOGGER.debug("\u5199\u51faPiece\uff1a{}", index);
        int offset = 0;
        long seek = 0L;
        int length = piece.getLength();
        long beginPos = piece.beginPos();
        long endPos = piece.endPos();
        if (beginPos <= this.fileBeginPos) {
            offset = (int)(this.fileBeginPos - beginPos);
            length -= offset;
        } else {
            seek = beginPos - this.fileBeginPos;
        }
        if (endPos >= this.fileEndPos) {
            length = (int)((long)length - (endPos - this.fileEndPos));
        }
        try {
            byte[] bytes = piece.getData();
            this.fileStream.seek(seek);
            this.fileStream.write(bytes, offset, length);
        }
        catch (IOException e) {
            LOGGER.error("\u5199\u51faPiece\u5f02\u5e38\uff1a{}-{}-{}-{}", index, seek, offset, length, e);
        }
    }

    private TorrentPiece cachePiece(int index) {
        for (TorrentPiece torrentPiece : this.cachePieces) {
            if (torrentPiece.getIndex() != index) continue;
            return torrentPiece;
        }
        return null;
    }

    private void buildPieces(boolean completed) {
        MessageDigest digest = DigestUtils.sha1();
        for (int index = this.fileBeginPieceIndex; index <= this.fileEndPieceIndex; ++index) {
            if (completed) {
                this.done(index);
                continue;
            }
            if (index == this.fileBeginPieceIndex) {
                if (!this.verify(index, digest)) continue;
                this.done(index);
                continue;
            }
            if (index == this.fileEndPieceIndex) {
                if (!this.verify(index, digest)) continue;
                this.done(index);
                continue;
            }
            if (!this.torrentStreamGroup.hasPiece(index)) continue;
            this.done(index);
        }
    }

    private void buildFileDownloadSize() {
        long size = 0L;
        int downloadPieceSize = this.pieces.cardinality();
        if (this.fileInOnePiece()) {
            if (this.hasPiece(this.fileBeginPieceIndex)) {
                size += (long)this.firstPieceSize();
                --downloadPieceSize;
            }
        } else {
            if (this.hasPiece(this.fileBeginPieceIndex)) {
                size += (long)this.firstPieceSize();
                --downloadPieceSize;
            }
            if (this.hasPiece(this.fileEndPieceIndex)) {
                size += (long)this.lastPieceSize();
                --downloadPieceSize;
            }
        }
        this.fileDownloadSize.set(size + (long)downloadPieceSize * this.pieceLength);
    }

    private boolean fileInOnePiece() {
        return this.fileBeginPieceIndex == this.fileEndPieceIndex;
    }

    private int firstPiecePos() {
        return (int)(this.fileBeginPos - (long)this.fileBeginPieceIndex * this.pieceLength);
    }

    private int firstPieceSize() {
        if (this.fileInOnePiece()) {
            return this.lastPiecePos() - this.firstPiecePos();
        }
        return (int)(this.pieceLength - (long)this.firstPiecePos());
    }

    private int lastPiecePos() {
        return (int)(this.fileEndPos - (long)this.fileEndPieceIndex * this.pieceLength);
    }

    private int lastPieceSize() {
        if (this.fileInOnePiece()) {
            return this.lastPiecePos() - this.firstPiecePos();
        }
        return this.lastPiecePos();
    }

    private boolean hasData(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        for (byte value : bytes) {
            if (value == 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasPiece(int index) {
        return this.pieces.get(index);
    }

    public String toString() {
        return BeanUtils.toString(this, this.filePath);
    }
}

