/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent;

import com.acgist.snail.config.DownloadConfig;
import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.torrent.Torrent;
import com.acgist.snail.net.torrent.TorrentFile;
import com.acgist.snail.net.torrent.TorrentPiece;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.TorrentStream;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.FileUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class TorrentStreamGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentStreamGroup.class);
    private volatile int piecePos = 0;
    private final BitSet pieces;
    private final BitSet selectPieces;
    private boolean full;
    private final BitSet fullPieces;
    private final AtomicLong fileBufferSize;
    private final Torrent torrent;
    private final List<TorrentStream> streams;
    private final TorrentSession torrentSession;
    private final ReadWriteLock readWriteLock;
    private final Lock readLock;
    private final Lock writeLock;

    private TorrentStreamGroup(TorrentSession torrentSession) {
        Torrent torrent = torrentSession.torrent();
        this.pieces = torrentSession.buildPieces();
        this.selectPieces = new BitSet(torrent.getInfo().pieceSize());
        this.full = false;
        this.fullPieces = new BitSet();
        this.fullPieces(this.pieces);
        this.fileBufferSize = new AtomicLong(0L);
        this.torrent = torrent;
        this.streams = new ArrayList<TorrentStream>();
        this.torrentSession = torrentSession;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
    }

    public static final TorrentStreamGroup newInstance(String folder, List<TorrentFile> files, TorrentSession torrentSession) {
        TorrentStreamGroup torrentStreamGroup = new TorrentStreamGroup(torrentSession);
        torrentStreamGroup.load(torrentSession.completed(), folder, files);
        return torrentStreamGroup;
    }

    public int reload(String folder, List<TorrentFile> files) {
        return this.load(false, folder, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int load(boolean completed, String folder, List<TorrentFile> files) {
        int loadFileCount = 0;
        if (CollectionUtils.isEmpty(files)) {
            LOGGER.error("\u4efb\u52a1\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff1a{}", files);
            return loadFileCount;
        }
        this.full = false;
        this.selectPieces.clear();
        this.writeLock.lock();
        try {
            long startTime = System.currentTimeMillis();
            long pos = 0L;
            long pieceLength = this.torrent.getInfo().getPieceLength();
            ArrayList<TorrentStream> sortList = new ArrayList<TorrentStream>();
            for (TorrentFile file : files) {
                long fileSize = file.getLength();
                String filePath = FileUtils.file(folder, file.path());
                TorrentStream oldStream = this.oldStream(filePath);
                try {
                    if (file.selected()) {
                        if (oldStream == null) {
                            LOGGER.debug("\u6587\u4ef6\u9009\u62e9\u4e0b\u8f7d\uff08\u52a0\u8f7d\uff09\uff1a{}", filePath);
                            ++loadFileCount;
                            TorrentStream newStream = TorrentStream.newInstance(pieceLength, filePath, fileSize, pos, completed, this);
                            this.streams.add(newStream);
                            newStream.buildSelectPieces(this.selectPieces);
                            newStream.install();
                            sortList.add(newStream);
                        } else {
                            LOGGER.debug("\u6587\u4ef6\u9009\u62e9\u4e0b\u8f7d\uff08\u91cd\u8f7d\uff09\uff1a{}", filePath);
                            if (!oldStream.selected()) {
                                ++loadFileCount;
                            }
                            oldStream.buildSelectPieces(this.selectPieces);
                            oldStream.install();
                            sortList.add(oldStream);
                        }
                    } else if (oldStream == null) {
                        LOGGER.debug("\u6587\u4ef6\u6ca1\u6709\u9009\u62e9\u4e0b\u8f7d\uff08\u5ffd\u7565\uff09\uff1a{}", filePath);
                    } else {
                        LOGGER.debug("\u6587\u4ef6\u6ca1\u6709\u9009\u62e9\u4e0b\u8f7d\uff08\u5378\u8f7d\uff09\uff1a{}", filePath);
                        oldStream.uninstall();
                        sortList.add(oldStream);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u65b0\u5efaTorrentStream\u5f02\u5e38\uff1a{}", filePath, e);
                }
                pos += fileSize;
            }
            this.streams.sort((source, target) -> {
                int sourceIndex = sortList.indexOf(source);
                int targetIndex = sortList.indexOf(target);
                return Integer.compare(sourceIndex, targetIndex);
            });
            long finishTime = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u4efb\u52a1\u52a0\u8f7d\u8017\u65f6\uff1a{}-{}", this.torrentSession, finishTime - startTime);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.torrentSession.downloadSize(this.downloadSize());
        this.fullPieces(this.pieces);
        return loadFileCount;
    }

    private TorrentStream oldStream(String path) {
        for (TorrentStream torrentStream : this.streams) {
            if (!torrentStream.equalsPath(path)) continue;
            return torrentStream;
        }
        return null;
    }

    public void have(int index) {
        this.torrentSession.have(index);
    }

    public void piecePos(int index) {
        if (PeerConfig.checkPiece(index) && !this.pieces.get(index) && this.selectPieces.get(index)) {
            LOGGER.debug("\u6307\u5b9a\u4e0b\u8f7dPiece\u7d22\u5f15\uff1a{}", index);
            this.piecePos = index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentPiece pick(BitSet peerPieces, BitSet suggestPieces) {
        TorrentPiece pickPiece = null;
        this.readLock.lock();
        try {
            for (TorrentStream torrentStream : this.streams) {
                if (!torrentStream.selected() || (pickPiece = torrentStream.pick(this.piecePos, peerPieces, suggestPieces)) == null) continue;
                break;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (pickPiece == null && this.piecePos != 0) {
            this.piecePos = 0;
            pickPiece = this.pick(peerPieces, suggestPieces);
        }
        return pickPiece;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(int index, int begin, int length) throws NetException {
        PacketSizeException.verify(length);
        ByteBuffer buffer = ByteBuffer.allocate(length);
        this.readLock.lock();
        try {
            for (TorrentStream torrentStream : this.streams) {
                byte[] bytes = torrentStream.read(index, length, begin);
                if (bytes == null) continue;
                buffer.put(bytes);
                if (buffer.position() < length) continue;
                break;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return buffer.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(TorrentPiece piece) {
        boolean success = false;
        this.readLock.lock();
        try {
            for (TorrentStream torrentStream : this.streams) {
                if (!torrentStream.write(piece)) continue;
                success = true;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (success) {
            this.have(piece.getIndex());
            long oldValue = this.fileBufferSize.addAndGet(piece.getLength());
            if (oldValue > (long)DownloadConfig.getMemoryBufferByte() && this.fileBufferSize.compareAndSet(oldValue, 0L)) {
                LOGGER.debug("\u7f13\u51b2\u533a\u88ab\u5360\u6ee1\uff1a{}", this.torrentSession);
                this.flush();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5df2\u7ecf\u4e0b\u8f7dPiece\u6570\u91cf\uff1a{}\n\u5269\u4f59\u4e0b\u8f7dPiece\u6570\u91cf\uff1a{}", this.pieces.cardinality(), this.remainingPieceSize());
        }
        return success;
    }

    public boolean hasPiece(int index) {
        if (index < 0) {
            return false;
        }
        return this.pieces.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done(int index) {
        BitSet bitSet = this.pieces;
        synchronized (bitSet) {
            this.pieces.set(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undone(int index) {
        BitSet bitSet = this.pieces;
        synchronized (bitSet) {
            this.pieces.clear(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undone(TorrentPiece piece) {
        this.readLock.lock();
        try {
            for (TorrentStream torrentStream : this.streams) {
                torrentStream.undone(piece);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public BitSet pieces() {
        return this.pieces;
    }

    public BitSet selectPieces() {
        return this.selectPieces;
    }

    public BitSet allPieces() {
        int pieceSize = this.torrent.getInfo().pieceSize();
        BitSet allPieces = new BitSet(pieceSize);
        allPieces.set(0, pieceSize);
        return allPieces;
    }

    public int remainingPieceSize() {
        BitSet condition = new BitSet();
        condition.or(this.selectPieces);
        condition.andNot(this.pieces);
        return condition.cardinality();
    }

    public void fullPieces() {
        if (this.full) {
            return;
        }
        this.full = true;
        this.fullPieces.clear();
    }

    public void fullPieces(BitSet pieces) {
        if (this.full) {
            return;
        }
        this.fullPieces.or(pieces);
        this.fullPieces.and(this.selectPieces);
        BitSet condition = new BitSet();
        condition.or(this.selectPieces);
        condition.andNot(this.fullPieces);
        if (condition.isEmpty()) {
            this.full = true;
            this.fullPieces.clear();
        }
    }

    public int health() {
        int health = 100;
        if (this.full) {
            return 100;
        }
        return this.fullPieces.cardinality() * 100 / this.selectPieces.cardinality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify() throws IOException {
        int verifyFailCount = 0;
        this.readLock.lock();
        try {
            for (TorrentStream torrentStream : this.streams) {
                if (!torrentStream.selected() || torrentStream.verify()) continue;
                ++verifyFailCount;
            }
            this.torrentSession.downloadSize(this.downloadSize());
        }
        finally {
            this.readLock.unlock();
        }
        return verifyFailCount == 0;
    }

    public byte[] pieceHash(int index) {
        byte[] pieceHashs = this.torrent.getInfo().getPieces();
        byte[] pieceHash = new byte[20];
        System.arraycopy(pieceHashs, index * 20, pieceHash, 0, 20);
        return pieceHash;
    }

    public void flush() {
        LOGGER.debug("\u5237\u51fa\u7f13\u5b58\uff1a{}", this.torrentSession);
        this.readLock.lock();
        try {
            for (TorrentStream torrentStream : this.streams) {
                torrentStream.flush();
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.torrentSession.updatePieces(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long downloadSize() {
        long downloadSize = 0L;
        this.readLock.lock();
        try {
            for (TorrentStream torrentStream : this.streams) {
                if (!torrentStream.selected()) continue;
                downloadSize += torrentStream.downloadSize();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return downloadSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completed() {
        this.readLock.lock();
        try {
            for (TorrentStream torrentStream : this.streams) {
                if (!torrentStream.selected() || torrentStream.completed()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void release() {
        LOGGER.debug("\u91ca\u653eTorrentStreamGroup\uff1a{}", this.torrentSession);
        this.readLock.lock();
        try {
            for (TorrentStream torrentStream : this.streams) {
                torrentStream.release();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }
}

