/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.codec;

import com.acgist.snail.net.NetException;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.utils.ByteUtils;
import com.acgist.snail.utils.DigestUtils;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public final class MSECipher {
    private static final String ARC4_ALGO = "ARCFOUR";
    private static final String ARC4_ALGO_TRANSFORMATION = "ARCFOUR/ECB/NoPadding";
    private static final String KEY_SEND = "keyA";
    private static final String KEY_RECV = "keyB";
    private final Cipher encryptCipher;
    private final Cipher decryptCipher;

    private MSECipher(Key encryptKey, Key decryptKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        this.encryptCipher = this.buildCipher(1, ARC4_ALGO_TRANSFORMATION, encryptKey);
        this.decryptCipher = this.buildCipher(2, ARC4_ALGO_TRANSFORMATION, decryptKey);
    }

    public static final MSECipher newSender(byte[] secret, InfoHash infoHash) throws NetException {
        Key sendKey = MSECipher.buildSendKey(secret, infoHash.getInfoHash());
        Key recvKey = MSECipher.buildRecvKey(secret, infoHash.getInfoHash());
        try {
            return new MSECipher(sendKey, recvKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new NetException("\u65b0\u5efa\u52a0\u5bc6\u5957\u4ef6\u5931\u8d25", e);
        }
    }

    public static final MSECipher newRecver(byte[] secret, InfoHash infoHash) throws NetException {
        Key sendKey = MSECipher.buildSendKey(secret, infoHash.getInfoHash());
        Key recvKey = MSECipher.buildRecvKey(secret, infoHash.getInfoHash());
        try {
            return new MSECipher(recvKey, sendKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new NetException("\u65b0\u5efa\u52a0\u5bc6\u5957\u4ef6\u5931\u8d25", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encrypt(ByteBuffer buffer) {
        byte[] encryptValue;
        boolean flip = true;
        if (buffer.position() != 0) {
            flip = false;
            buffer.flip();
        }
        byte[] value = ByteUtils.remainingToBytes(buffer);
        Cipher cipher = this.encryptCipher;
        synchronized (cipher) {
            encryptValue = this.encryptCipher.update(value);
        }
        buffer.clear().put(encryptValue);
        if (flip) {
            buffer.flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] bytes) throws NetException {
        try {
            Cipher cipher = this.encryptCipher;
            synchronized (cipher) {
                return this.encryptCipher.doFinal(bytes);
            }
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new NetException("\u6570\u636e\u52a0\u5bc6\u5f02\u5e38", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrypt(ByteBuffer buffer) {
        byte[] decryptValue;
        boolean flip = true;
        if (buffer.position() != 0) {
            flip = false;
            buffer.flip();
        }
        byte[] value = ByteUtils.remainingToBytes(buffer);
        Cipher cipher = this.decryptCipher;
        synchronized (cipher) {
            decryptValue = this.decryptCipher.update(value);
        }
        buffer.clear().put(decryptValue);
        if (flip) {
            buffer.flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] bytes) throws NetException {
        try {
            Cipher cipher = this.decryptCipher;
            synchronized (cipher) {
                return this.decryptCipher.doFinal(bytes);
            }
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new NetException("\u6570\u636e\u89e3\u5bc6\u5f02\u5e38", e);
        }
    }

    private static final Key buildSendKey(byte[] secret, byte[] skey) {
        return MSECipher.buildKey(KEY_SEND, secret, skey);
    }

    private static final Key buildRecvKey(byte[] secret, byte[] skey) {
        return MSECipher.buildKey(KEY_RECV, secret, skey);
    }

    private static final Key buildKey(String key, byte[] secret, byte[] skey) {
        MessageDigest digest = DigestUtils.sha1();
        digest.update(key.getBytes());
        digest.update(secret);
        digest.update(skey);
        return new SecretKeySpec(digest.digest(), ARC4_ALGO);
    }

    private Cipher buildCipher(int mode, String transformation, Key key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(mode, key);
        cipher.update(new byte[1024]);
        return cipher;
    }
}

