/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.codec;

import com.acgist.snail.config.CryptConfig;
import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.codec.MSECipher;
import com.acgist.snail.net.torrent.codec.MSEKeyPairBuilder;
import com.acgist.snail.net.torrent.codec.MSEPaddingSync;
import com.acgist.snail.net.torrent.codec.PeerUnpackMessageCodec;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.DigestUtils;
import com.acgist.snail.utils.NumberUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;

public final class MSECryptHandshakeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MSECryptHandshakeHandler.class);
    private static final int BUFFER_LENGTH = 4096;
    private static final byte[] REQ1 = "req1".getBytes();
    private static final byte[] REQ2 = "req2".getBytes();
    private static final byte[] REQ3 = "req3".getBytes();
    private Step step = Step.RECEIVE_PUBLIC_KEY;
    private volatile boolean crypt = false;
    private volatile boolean completed = false;
    private final Object handshakeLock = new Object();
    private MSECipher cipher;
    private MSECipher cipherVC;
    private KeyPair keyPair;
    private CryptConfig.Strategy strategy;
    private ByteBuffer buffer;
    private BigInteger dhSecret;
    private MSEPaddingSync msePaddingSync;
    private final PeerSubMessageHandler peerSubMessageHandler;
    private final PeerUnpackMessageCodec peerUnpackMessageCodec;
    private static final int PUBLIC_KEY_MIN_LENGTH = 96;
    private static final int PUBLIC_KEY_MAX_LENGTH = 608;
    private static final int PROVIDE_MIN_LENGTH = 56;
    private static final int PROVIDE_MAX_LENGTH = 568;
    private static final int CONFIRM_MIN_LENGTH = 14;
    private static final int CONFIRM_MAX_LENGTH = 526;

    private MSECryptHandshakeHandler(PeerUnpackMessageCodec peerUnpackMessageCodec, PeerSubMessageHandler peerSubMessageHandler) {
        MSEKeyPairBuilder mseKeyPairBuilder = MSEKeyPairBuilder.newInstance();
        this.buffer = ByteBuffer.allocate(4096);
        this.keyPair = mseKeyPairBuilder.buildKeyPair();
        this.peerSubMessageHandler = peerSubMessageHandler;
        this.peerUnpackMessageCodec = peerUnpackMessageCodec;
    }

    public static final MSECryptHandshakeHandler newInstance(PeerUnpackMessageCodec peerUnpackMessageCodec, PeerSubMessageHandler peerSubMessageHandler) {
        return new MSECryptHandshakeHandler(peerUnpackMessageCodec, peerSubMessageHandler);
    }

    public void plaintext() {
        this.completed(false);
    }

    public boolean completed() {
        return this.completed;
    }

    public void handshake() {
        this.step = Step.SEND_PUBLIC_KEY;
        this.sendPublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshake(ByteBuffer message) throws NetException {
        try {
            if (this.checkPlaintextPeerHandshake(message)) {
                LOGGER.debug("\u8df3\u8fc7\u52a0\u5bc6\u63e1\u624b\uff1a\u6536\u5230Peer\u660e\u6587\u63e1\u624b\u6d88\u606f", new Object[0]);
                this.peerUnpackMessageCodec.decode(message);
                return;
            }
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                switch (this.step) {
                    case SEND_PUBLIC_KEY: 
                    case RECEIVE_PUBLIC_KEY: {
                        this.buffer.put(message);
                        this.receivePublicKey();
                        break;
                    }
                    case RECEIVE_PROVIDE: {
                        this.buffer.put(message);
                        this.receiveProvide();
                        break;
                    }
                    case RECEIVE_PROVIDE_PADDING: {
                        this.cipher.decrypt(message);
                        this.buffer.put(message);
                        this.receiveProvidePadding();
                        break;
                    }
                    case RECEIVE_CONFIRM: {
                        this.buffer.put(message);
                        this.receiveConfirm();
                        break;
                    }
                    case RECEIVE_CONFIRM_PADDING: {
                        this.cipher.decrypt(message);
                        this.buffer.put(message);
                        this.receiveConfirmPadding();
                        break;
                    }
                    default: {
                        LOGGER.warn("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25\uff08\u6b65\u9aa4\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{this.step});
                    }
                }
            }
        }
        catch (NetException e) {
            this.plaintext();
            throw e;
        }
        catch (Exception e) {
            this.plaintext();
            throw new NetException("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25", e);
        }
    }

    public boolean available() {
        return this.peerSubMessageHandler.available();
    }

    public boolean needEncrypt() {
        return this.peerSubMessageHandler.needEncrypt();
    }

    public void encrypt(ByteBuffer buffer) {
        if (this.crypt) {
            this.cipher.encrypt(buffer);
        }
    }

    public void decrypt(ByteBuffer buffer) {
        if (this.crypt) {
            this.cipher.decrypt(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockHandshake() {
        if (!this.completed) {
            Object object = this.handshakeLock;
            synchronized (object) {
                if (!this.completed) {
                    try {
                        this.handshakeLock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
            }
        }
        if (!this.completed) {
            LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25\uff1a\u4f7f\u7528\u660e\u6587", new Object[0]);
            this.plaintext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockHandshake() {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.handshakeLock.notifyAll();
        }
    }

    private void sendPublicKey() {
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u53d1\u9001\u516c\u94a5\uff09\u6b65\u9aa4\uff1a{}", new Object[]{this.step});
        byte[] publicKey = this.keyPair.getPublic().getEncoded();
        byte[] padding = this.buildPadding(512);
        ByteBuffer message = ByteBuffer.allocate(publicKey.length + padding.length);
        message.put(publicKey);
        message.put(padding);
        this.peerSubMessageHandler.send(message);
    }

    private void receivePublicKey() throws NetException {
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u63a5\u6536\u516c\u94a5\uff09\u6b65\u9aa4\uff1a{}", new Object[]{this.step});
        if (this.buffer.position() < 96) {
            return;
        }
        if (this.buffer.position() > 608) {
            throw new NetException("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25\uff08\u516c\u94a5\u957f\u5ea6\u9519\u8bef\uff09");
        }
        this.buffer.flip();
        BigInteger publicKey = NumberUtils.decodeBigInteger(this.buffer, 96);
        this.buffer.compact();
        this.dhSecret = ((MSEKeyPairBuilder.MSEPrivateKey)this.keyPair.getPrivate()).buildDHSecret(publicKey);
        if (this.step == Step.RECEIVE_PUBLIC_KEY) {
            this.sendPublicKey();
            this.step = Step.RECEIVE_PROVIDE;
        } else if (this.step == Step.SEND_PUBLIC_KEY) {
            this.sendProvide();
            this.step = Step.RECEIVE_CONFIRM;
        } else {
            LOGGER.warn("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25\uff08\u63a5\u6536\u516c\u94a5\u672a\u77e5\u6b65\u9aa4\uff09\uff1a{}", new Object[]{this.step});
        }
    }

    private void sendProvide() throws NetException {
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u53d1\u9001\u52a0\u5bc6\u534f\u8bae\u534f\u5546\uff09\u6b65\u9aa4\uff1a{}", new Object[]{this.step});
        TorrentSession torrentSession = this.peerSubMessageHandler.torrentSession();
        if (torrentSession == null) {
            throw new NetException("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25\uff08\u79cd\u5b50\u4fe1\u606f\u4e0d\u5b58\u5728\uff09");
        }
        byte[] dhSecretBytes = NumberUtils.encodeBigInteger(this.dhSecret, 96);
        InfoHash infoHash = torrentSession.infoHash();
        this.cipher = MSECipher.newSender(dhSecretBytes, infoHash);
        this.cipherVC = MSECipher.newSender(dhSecretBytes, infoHash);
        ByteBuffer message = ByteBuffer.allocate(40);
        MessageDigest digest = DigestUtils.sha1();
        digest.update(REQ1);
        digest.update(dhSecretBytes);
        message.put(digest.digest());
        digest.reset();
        digest.update(REQ2);
        digest.update(infoHash.getInfoHash());
        byte[] req2 = digest.digest();
        digest.reset();
        digest.update(REQ3);
        digest.update(dhSecretBytes);
        byte[] req3 = digest.digest();
        message.put(ArrayUtils.xor(req2, req3));
        this.peerSubMessageHandler.send(message);
        byte[] padding = this.buildZeroPadding(512);
        int paddingLength = padding.length;
        message = ByteBuffer.allocate(16 + paddingLength);
        message.put(CryptConfig.VC);
        message.putInt(CryptConfig.STRATEGY.getProvide());
        message.putShort((short)paddingLength);
        message.put(padding);
        message.putShort((short)0);
        this.cipher.encrypt(message);
        this.peerSubMessageHandler.send(message);
    }

    private void receiveProvide() throws NetException {
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u63a5\u6536\u52a0\u5bc6\u534f\u8bae\u534f\u5546\uff09\u6b65\u9aa4\uff1a{}", new Object[]{this.step});
        byte[] dhSecretBytes = NumberUtils.encodeBigInteger(this.dhSecret, 96);
        MessageDigest digest = DigestUtils.sha1();
        digest.update(REQ1);
        digest.update(dhSecretBytes);
        byte[] req1 = digest.digest();
        if (!this.match(req1)) {
            return;
        }
        if (this.buffer.position() < 56) {
            return;
        }
        if (this.buffer.position() > 568) {
            throw new NetException("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25\uff08\u52a0\u5bc6\u534f\u5546\u957f\u5ea6\u9519\u8bef\uff09");
        }
        this.buffer.flip();
        byte[] req1Peer = new byte[20];
        this.buffer.get(req1Peer);
        byte[] req2x3Peer = new byte[20];
        this.buffer.get(req2x3Peer);
        digest.reset();
        digest.update(REQ3);
        digest.update(dhSecretBytes);
        byte[] req3 = digest.digest();
        InfoHash infoHash = null;
        for (InfoHash infoHashMatch : TorrentContext.getInstance().allInfoHash()) {
            digest.reset();
            digest.update(REQ2);
            digest.update(infoHashMatch.getInfoHash());
            byte[] req2 = digest.digest();
            if (!Arrays.equals(ArrayUtils.xor(req2, req3), req2x3Peer)) continue;
            infoHash = infoHashMatch;
            break;
        }
        if (infoHash == null) {
            throw new NetException("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25\uff08\u79cd\u5b50\u4fe1\u606f\u4e0d\u5b58\u5728\uff09");
        }
        this.cipher = MSECipher.newRecver(dhSecretBytes, infoHash);
        this.buffer.compact();
        this.buffer.flip();
        this.cipher.decrypt(this.buffer);
        byte[] vc = new byte[CryptConfig.VC_LENGTH];
        this.buffer.get(vc);
        int provide = this.buffer.getInt();
        this.strategy = this.selectStrategy(provide);
        this.step = Step.RECEIVE_PROVIDE_PADDING;
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u63a5\u6536\u52a0\u5bc6\u534f\u8bae\u534f\u5546-\u786e\u8ba4\u52a0\u5bc6\u534f\u8bae\uff09\uff1a{} - {}", new Object[]{provide, this.strategy});
        this.msePaddingSync = MSEPaddingSync.newInstance(2);
        this.receiveProvidePadding();
    }

    private void receiveProvidePadding() throws PacketSizeException {
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u63a5\u6536\u52a0\u5bc6\u534f\u8bae\u534f\u5546Padding\uff09\u6b65\u9aa4\uff1a{}", new Object[]{this.step});
        boolean success = this.msePaddingSync.sync(this.buffer);
        if (success) {
            LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u63a5\u6536\u52a0\u5bc6\u534f\u8bae\u534f\u5546Padding\uff09\uff1a{}", this.msePaddingSync);
            this.sendConfirm();
        }
    }

    private void sendConfirm() {
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u53d1\u9001\u786e\u8ba4\u52a0\u5bc6\u534f\u8bae\uff09\u6b65\u9aa4\uff1a{}", new Object[]{this.step});
        byte[] padding = this.buildZeroPadding(512);
        int paddingLength = padding.length;
        ByteBuffer message = ByteBuffer.allocate(14 + paddingLength);
        message.put(CryptConfig.VC);
        message.putInt(this.strategy.getProvide());
        message.putShort((short)paddingLength);
        message.put(padding);
        this.cipher.encrypt(message);
        this.peerSubMessageHandler.send(message);
        this.completed(this.strategy.getCrypt());
    }

    private void receiveConfirm() throws NetException {
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u63a5\u6536\u786e\u8ba4\u52a0\u5bc6\u534f\u8bae\uff09\u6b65\u9aa4\uff1a{}", new Object[]{this.step});
        byte[] vcMatch = this.cipherVC.decrypt(CryptConfig.VC);
        if (!this.match(vcMatch)) {
            return;
        }
        if (this.buffer.position() < 14) {
            return;
        }
        if (this.buffer.position() > 526) {
            throw new NetException("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25\uff08\u786e\u8ba4\u52a0\u5bc6\u957f\u5ea6\u9519\u8bef\uff09");
        }
        this.buffer.flip();
        this.cipher.decrypt(this.buffer);
        byte[] vc = new byte[CryptConfig.VC_LENGTH];
        this.buffer.get(vc);
        int provide = this.buffer.getInt();
        this.strategy = this.selectStrategy(provide);
        this.step = Step.RECEIVE_CONFIRM_PADDING;
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u63a5\u6536\u786e\u8ba4\u52a0\u5bc6\u534f\u8bae-\u786e\u8ba4\u52a0\u5bc6\u534f\u8bae\uff09\uff1a{} - {}", new Object[]{provide, this.strategy});
        this.msePaddingSync = MSEPaddingSync.newInstance(1);
        this.receiveConfirmPadding();
    }

    private void receiveConfirmPadding() throws PacketSizeException {
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u63a5\u6536\u786e\u8ba4\u52a0\u5bc6\u534f\u8baePadding\uff09\u6b65\u9aa4\uff1a{}", new Object[]{this.step});
        boolean success = this.msePaddingSync.sync(this.buffer);
        if (success) {
            LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\uff08\u63a5\u6536\u786e\u8ba4\u52a0\u5bc6\u534f\u8baePadding\uff09\uff1a{}", this.msePaddingSync);
            this.completed(this.strategy.getCrypt());
        }
    }

    private CryptConfig.Strategy selectStrategy(int provide) throws NetException {
        boolean plaintext = (provide & CryptConfig.CryptAlgo.PLAINTEXT.getProvide()) == CryptConfig.CryptAlgo.PLAINTEXT.getProvide();
        boolean crypt = (provide & CryptConfig.CryptAlgo.ARC4.getProvide()) == CryptConfig.CryptAlgo.ARC4.getProvide();
        CryptConfig.Strategy selected = null;
        if (plaintext || crypt) {
            switch (CryptConfig.STRATEGY) {
                case PLAINTEXT: {
                    CryptConfig.Strategy strategy;
                    if (plaintext) {
                        strategy = CryptConfig.Strategy.PLAINTEXT;
                        break;
                    }
                    strategy = null;
                    break;
                }
                case PREFER_PLAINTEXT: {
                    CryptConfig.Strategy strategy;
                    if (plaintext) {
                        strategy = CryptConfig.Strategy.PLAINTEXT;
                        break;
                    }
                    strategy = CryptConfig.Strategy.ENCRYPT;
                    break;
                }
                case PREFER_ENCRYPT: {
                    CryptConfig.Strategy strategy;
                    if (crypt) {
                        strategy = CryptConfig.Strategy.ENCRYPT;
                        break;
                    }
                    strategy = CryptConfig.Strategy.PLAINTEXT;
                    break;
                }
                case ENCRYPT: {
                    CryptConfig.Strategy strategy;
                    if (crypt) {
                        strategy = CryptConfig.Strategy.ENCRYPT;
                        break;
                    }
                    strategy = null;
                    break;
                }
                default: {
                    CryptConfig.Strategy strategy = selected = CryptConfig.STRATEGY.getCrypt() ? CryptConfig.Strategy.ENCRYPT : CryptConfig.Strategy.PLAINTEXT;
                }
            }
        }
        if (selected == null) {
            throw new NetException("\u52a0\u5bc6\u63e1\u624b\u5931\u8d25\uff08\u672a\u77e5\u52a0\u5bc6\u534f\u5546\uff09\uff1a" + provide);
        }
        return selected;
    }

    private byte[] buildPadding(int maxLength) {
        return ArrayUtils.random(this.randomLength(maxLength));
    }

    private byte[] buildZeroPadding(int maxLength) {
        return new byte[this.randomLength(maxLength)];
    }

    private int randomLength(int maxLength) {
        SecureRandom random = NumberUtils.random();
        return random.nextInt(maxLength + 1);
    }

    private boolean checkPlaintextPeerHandshake(ByteBuffer message) {
        byte first = message.get();
        if (first == PeerConfig.PROTOCOL_NAME_LENGTH && message.remaining() >= PeerConfig.PROTOCOL_NAME_LENGTH) {
            byte[] name = new byte[PeerConfig.PROTOCOL_NAME_LENGTH];
            message.get(name);
            if (Arrays.equals(name, PeerConfig.PROTOCOL_NAME_BYTES)) {
                this.plaintext();
                message.rewind();
                return true;
            }
        }
        message.rewind();
        return false;
    }

    private boolean match(byte[] bytes) {
        int length = bytes.length;
        this.buffer.flip();
        if (this.buffer.remaining() < length) {
            this.buffer.compact();
            return false;
        }
        int index = 0;
        while (length > index) {
            if (this.buffer.get() != bytes[index]) {
                this.buffer.position(this.buffer.position() - index);
                index = 0;
                if (this.buffer.remaining() >= length) continue;
                break;
            }
            ++index;
        }
        if (index == length) {
            this.buffer.position(this.buffer.position() - length);
            this.buffer.compact();
            return true;
        }
        this.buffer.compact();
        return false;
    }

    private void completed(boolean crypt) {
        LOGGER.debug("\u52a0\u5bc6\u63e1\u624b\u5b8c\u6210\uff1a{}", crypt);
        this.crypt = crypt;
        this.completed = true;
        this.buffer = null;
        this.keyPair = null;
        this.strategy = null;
        this.dhSecret = null;
        this.cipherVC = null;
        this.msePaddingSync = null;
        this.unlockHandshake();
    }

    public static enum Step {
        SEND_PUBLIC_KEY,
        RECEIVE_PUBLIC_KEY,
        SEND_PROVIDE,
        RECEIVE_PROVIDE,
        RECEIVE_PROVIDE_PADDING,
        SEND_CONFIRM,
        RECEIVE_CONFIRM,
        RECEIVE_CONFIRM_PADDING;

    }
}

