/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.codec;

import com.acgist.snail.config.CryptConfig;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.NumberUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class MSEKeyPairBuilder {
    private static final String ALGORITHM = "DH";
    private static final String FORMAT = "MSE";

    private MSEKeyPairBuilder() {
    }

    public static final MSEKeyPairBuilder newInstance() {
        return new MSEKeyPairBuilder();
    }

    public KeyPair buildKeyPair() {
        MSEPrivateKey privateKey = new MSEPrivateKey();
        MSEPublicKey publicKey = privateKey.getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    public static final class MSEPrivateKey
    implements PrivateKey {
        private static final long serialVersionUID = 1L;
        private final BigInteger value = this.buildPrivateKey();
        private final MSEPublicKey publicKey = this.buildPublicKey();

        private MSEPrivateKey() {
        }

        private BigInteger buildPrivateKey() {
            byte[] bytes = ArrayUtils.random(128);
            return NumberUtils.decodeBigInteger(ByteBuffer.wrap(bytes), 128);
        }

        private MSEPublicKey buildPublicKey() {
            return new MSEPublicKey(CryptConfig.G.modPow(this.value, CryptConfig.P));
        }

        public BigInteger buildDHSecret(BigInteger publicKey) {
            return publicKey.modPow(this.value, CryptConfig.P);
        }

        private MSEPublicKey getPublicKey() {
            return this.publicKey;
        }

        @Override
        public String getAlgorithm() {
            return MSEKeyPairBuilder.ALGORITHM;
        }

        @Override
        public String getFormat() {
            return MSEKeyPairBuilder.FORMAT;
        }

        @Override
        public byte[] getEncoded() {
            return this.value.toByteArray();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static final class MSEPublicKey
    implements PublicKey {
        private static final long serialVersionUID = 1L;
        private final BigInteger value;

        private MSEPublicKey(BigInteger value) {
            this.value = value;
        }

        @Override
        public String getAlgorithm() {
            return MSEKeyPairBuilder.ALGORITHM;
        }

        @Override
        public String getFormat() {
            return MSEKeyPairBuilder.FORMAT;
        }

        @Override
        public byte[] getEncoded() {
            return NumberUtils.encodeBigInteger(this.value, 96);
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

