/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.codec;

import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.StringUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class MSEPaddingSync {
    private int count;
    private byte[] bytes;
    private short length = (short)-1;
    private final List<byte[]> list;

    private MSEPaddingSync(int count) {
        this.count = count;
        this.list = new ArrayList<byte[]>(count);
    }

    public static final MSEPaddingSync newInstance(int count) {
        return new MSEPaddingSync(count);
    }

    public boolean sync(ByteBuffer buffer) throws PacketSizeException {
        if (this.count == 0) {
            return true;
        }
        if (!buffer.hasRemaining()) {
            return false;
        }
        if (this.length == -1) {
            if (buffer.remaining() < 2) {
                return false;
            }
            this.length = buffer.getShort();
            PacketSizeException.verify(this.length);
            this.bytes = new byte[this.length];
        }
        int remaining = buffer.remaining();
        if (this.length == 0) {
            --this.count;
            this.length = (short)-1;
            this.list.add(this.bytes);
            buffer.compact().flip();
            return this.sync(buffer);
        }
        if (remaining >= this.length) {
            buffer.get(this.bytes, this.bytes.length - this.length, this.length);
            --this.count;
            this.length = (short)-1;
            this.list.add(this.bytes);
            buffer.compact().flip();
            return this.sync(buffer);
        }
        buffer.get(this.bytes, this.bytes.length - this.length, remaining);
        this.length = (short)(this.length - remaining);
        buffer.compact();
        return false;
    }

    public String toString() {
        List padding = this.list.stream().map(StringUtils::hex).collect(Collectors.toList());
        return BeanUtils.toString(this, this.count, this.length, padding);
    }
}

