/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.codec;

import com.acgist.snail.config.CryptConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.codec.MessageCodec;
import com.acgist.snail.net.torrent.codec.MSECryptHandshakeHandler;
import com.acgist.snail.net.torrent.codec.PeerUnpackMessageCodec;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public final class PeerCryptMessageCodec
extends MessageCodec<ByteBuffer, ByteBuffer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerCryptMessageCodec.class);
    private final MSECryptHandshakeHandler mseCryptHandshakeHandler;

    public PeerCryptMessageCodec(PeerUnpackMessageCodec peerUnpackMessageCodec, PeerSubMessageHandler peerSubMessageHandler) {
        super(peerUnpackMessageCodec);
        this.mseCryptHandshakeHandler = MSECryptHandshakeHandler.newInstance(peerUnpackMessageCodec, peerSubMessageHandler);
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) {
        if (this.mseCryptHandshakeHandler.completed()) {
            this.mseCryptHandshakeHandler.encrypt(buffer);
        } else {
            boolean encrypt;
            boolean bl = encrypt = this.mseCryptHandshakeHandler.needEncrypt() && CryptConfig.STRATEGY.getCrypt();
            if (encrypt) {
                this.mseCryptHandshakeHandler.handshake();
                this.mseCryptHandshakeHandler.lockHandshake();
                this.mseCryptHandshakeHandler.encrypt(buffer);
            } else {
                this.mseCryptHandshakeHandler.plaintext();
            }
        }
        return buffer;
    }

    @Override
    public void doDecode(ByteBuffer buffer, InetSocketAddress address) throws NetException {
        if (this.mseCryptHandshakeHandler.available()) {
            if (this.mseCryptHandshakeHandler.completed()) {
                this.mseCryptHandshakeHandler.decrypt(buffer);
                this.doNext(buffer, address);
            } else {
                this.mseCryptHandshakeHandler.handshake(buffer);
            }
        } else {
            LOGGER.debug("Peer\u6d88\u606f\u4ee3\u7406\u4e0d\u53ef\u7528\uff1a\u5ffd\u7565\u6d88\u606f\u89e3\u5bc6", new Object[0]);
        }
    }
}

