/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.codec;

import com.acgist.snail.net.NetException;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.codec.MessageCodec;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public final class PeerUnpackMessageCodec
extends MessageCodec<ByteBuffer, ByteBuffer> {
    private ByteBuffer buffer;
    private final ByteBuffer lengthStick = ByteBuffer.allocate(4);
    private final PeerSubMessageHandler peerSubMessageHandler;

    public PeerUnpackMessageCodec(PeerSubMessageHandler peerSubMessageHandler) {
        super(peerSubMessageHandler);
        this.peerSubMessageHandler = peerSubMessageHandler;
    }

    @Override
    public void doDecode(ByteBuffer buffer, InetSocketAddress address) throws NetException {
        block10: {
            byte[] bytes;
            int remaining;
            int length = 0;
            while (true) {
                if (this.buffer == null) {
                    if (this.peerSubMessageHandler.handshakeRecv()) {
                        while (this.lengthStick.hasRemaining() && buffer.hasRemaining()) {
                            this.lengthStick.put(buffer.get());
                        }
                        if (this.lengthStick.hasRemaining()) break block10;
                        this.lengthStick.flip();
                        length = this.lengthStick.getInt();
                        this.lengthStick.compact();
                    } else {
                        length = 68;
                    }
                    if (length <= 0) {
                        this.peerSubMessageHandler.keepAlive();
                        if (buffer.hasRemaining()) {
                            continue;
                        }
                        break block10;
                    }
                    PacketSizeException.verify(length);
                    this.buffer = ByteBuffer.allocate(length);
                } else {
                    length = this.buffer.capacity() - this.buffer.position();
                }
                remaining = buffer.remaining();
                if (remaining > length) {
                    bytes = new byte[length];
                    buffer.get(bytes);
                    this.buffer.put(bytes);
                    this.buffer.flip();
                    this.doNext(this.buffer, address);
                    this.buffer = null;
                    continue;
                }
                if (remaining == length) {
                    bytes = new byte[length];
                    buffer.get(bytes);
                    this.buffer.put(bytes);
                    this.buffer.flip();
                    this.doNext(this.buffer, address);
                    this.buffer = null;
                    break block10;
                }
                if (remaining < length) break;
            }
            bytes = new byte[remaining];
            buffer.get(bytes);
            this.buffer.put(bytes);
        }
    }
}

