/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht;

import com.acgist.snail.net.UdpClient;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.TorrentServer;
import com.acgist.snail.net.torrent.dht.DhtMessageHandler;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class DhtClient
extends UdpClient<DhtMessageHandler> {
    private DhtClient(InetSocketAddress socketAddress) {
        super("DHT Client", new DhtMessageHandler(socketAddress));
    }

    public static final DhtClient newInstance(String host, int port) {
        return DhtClient.newInstance(NetUtils.buildSocketAddress(host, port));
    }

    public static final DhtClient newInstance(InetSocketAddress socketAddress) {
        return new DhtClient(socketAddress);
    }

    @Override
    public boolean open() {
        return this.open((DatagramChannel)TorrentServer.getInstance().getChannel());
    }

    public NodeSession ping() {
        return ((DhtMessageHandler)this.handler).ping();
    }

    public void findNode(String target) {
        this.findNode(StringUtils.unhex(target));
    }

    public void findNode(byte[] target) {
        ((DhtMessageHandler)this.handler).findNode(target);
    }

    public void getPeers(InfoHash infoHash) {
        this.getPeers(infoHash.getInfoHash());
    }

    public void getPeers(byte[] infoHash) {
        ((DhtMessageHandler)this.handler).getPeers(infoHash);
    }

    public void announcePeer(byte[] token, InfoHash infoHash) {
        this.announcePeer(token, infoHash.getInfoHash());
    }

    public void announcePeer(byte[] token, byte[] infoHash) {
        ((DhtMessageHandler)this.handler).announcePeer(token, infoHash);
    }
}

