/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht;

import com.acgist.snail.context.IContext;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.dht.DhtRequest;
import com.acgist.snail.net.torrent.dht.DhtResponse;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.utils.NumberUtils;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DhtContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DhtContext.class);
    private static final DhtContext INSTANCE = new DhtContext();
    private static final int TOKEN_LENGTH = 8;
    private static final String TOKEN_CHARACTER = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final byte[] token;
    private short requestId = Short.MIN_VALUE;
    private final List<DhtRequest> requests;

    public static final DhtContext getInstance() {
        return INSTANCE;
    }

    private DhtContext() {
        this.token = this.buildToken();
        this.requests = new LinkedList<DhtRequest>();
        SystemThreadContext.scheduledAtFixedDelay(8L, 8L, TimeUnit.MINUTES, this::timeout);
    }

    public byte[] token() {
        return this.token;
    }

    private byte[] buildToken() {
        byte[] token = new byte[8];
        byte[] bytes = TOKEN_CHARACTER.getBytes();
        int length = bytes.length;
        SecureRandom random = NumberUtils.random();
        for (int index = 0; index < 8; ++index) {
            token[index] = bytes[random.nextInt(length)];
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u751f\u6210DHT\u7684Token\uff1a{}", new String(token));
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] buildRequestId() {
        DhtContext dhtContext = this;
        synchronized (dhtContext) {
            short s = this.requestId;
            this.requestId = (short)(s + 1);
            return NumberUtils.shortToBytes(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(DhtRequest request) {
        if (request == null) {
            return;
        }
        List<DhtRequest> list = this.requests;
        synchronized (list) {
            DhtRequest oldRequest = this.remove(request.getT());
            if (oldRequest != null) {
                LOGGER.debug("\u5220\u9664\u6ca1\u6709\u6536\u5230\u54cd\u5e94\u7684DHT\u8bf7\u6c42\uff1a{}", oldRequest);
            }
            this.requests.add(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DhtRequest response(DhtResponse response) {
        DhtRequest request;
        if (response == null) {
            return null;
        }
        NodeContext.getInstance().available(response.getNodeId());
        List<DhtRequest> list = this.requests;
        synchronized (list) {
            request = this.remove(response.getT());
        }
        if (request != null) {
            request.setResponse(response);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout() {
        long timeout = 5000L;
        long timestamp = System.currentTimeMillis();
        List<DhtRequest> list = this.requests;
        synchronized (list) {
            int oldSize = this.requests.size();
            Iterator<DhtRequest> iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                DhtRequest request = iterator.next();
                if (timestamp - request.getTimestamp() <= 5000L) continue;
                iterator.remove();
            }
            int newSize = this.requests.size();
            LOGGER.debug("\u5904\u7406DHT\u8d85\u65f6\u8bf7\u6c42\n\u5904\u7406\u4e4b\u524d\u8bf7\u6c42\u6570\u91cf\uff1a{}\n\u5904\u7406\u4e4b\u540e\u8bf7\u6c42\u6570\u91cf\uff1a{}\n", oldSize, newSize);
        }
    }

    private DhtRequest remove(byte[] id) {
        Iterator<DhtRequest> iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            DhtRequest request = iterator.next();
            if (!Arrays.equals(id, request.getT())) continue;
            iterator.remove();
            return request;
        }
        return null;
    }
}

